/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.function.Function;

public final class ObjectReaderImplListStr
implements ObjectReader {
    final Class listType;
    final Class instanceType;

    public ObjectReaderImplListStr(Class listType, Class instanceType) {
        this.listType = listType;
        this.instanceType = instanceType;
    }

    public Object createInstance(long features) {
        if (this.instanceType == ArrayList.class) {
            return new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create list error, type " + this.instanceType);
        }
    }

    public Object createInstance(Collection collection) {
        if (this.listType.isInstance(collection)) {
            boolean typeMatch = true;
            for (Object item : collection) {
                if (item instanceof String) continue;
                typeMatch = false;
                break;
            }
            if (typeMatch) {
                return collection;
            }
        }
        Collection typedList = (Collection)this.createInstance(0L);
        for (Object item : collection) {
            if (item == null || item instanceof String) {
                typedList.add(item);
                continue;
            }
            typedList.add(JSON.toJSONString(item));
        }
        return typedList;
    }

    public Class getObjectClass() {
        return this.listType;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    public Object readJSONBObject(JSONReader jsonReader, long features) {
        Collection<Object> list;
        Class listType = this.listType;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader objectReader = jsonReader.checkAutoType(listType, 0L, features);
        if (objectReader != null) {
            listType = objectReader.getObjectClass();
        }
        if (listType == ObjectReaderImplList.CLASS_ARRAYS_LIST) {
            int entryCnt = jsonReader.startArray();
            String[] array = new String[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readString();
            }
            return Arrays.asList(array);
        }
        Function<Collection, Collection> builder = null;
        if (listType == ArrayList.class) {
            list = new ArrayList();
        } else if (listType == JSONArray.class) {
            list = new JSONArray();
        } else if (listType == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION) {
            list = new ArrayList();
            builder = Collections::unmodifiableCollection;
        } else if (listType == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST) {
            list = new ArrayList();
            builder = Collections::unmodifiableList;
        } else if (listType == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET) {
            list = new LinkedHashSet();
            builder = Collections::unmodifiableSet;
        } else if (listType == ObjectReaderImplList.CLASS_UNMODIFIABLE_SORTED_SET) {
            list = new TreeSet();
            builder = Collections::unmodifiableSortedSet;
        } else if (listType == ObjectReaderImplList.CLASS_UNMODIFIABLE_NAVIGABLE_SET) {
            list = new TreeSet();
            builder = Collections::unmodifiableNavigableSet;
        } else if (listType == ObjectReaderImplList.CLASS_SINGLETON) {
            list = new ArrayList();
            builder = collection -> Collections.singleton(collection.iterator().next());
        } else if (listType == ObjectReaderImplList.CLASS_SINGLETON_LIST) {
            list = new ArrayList();
            builder = collection -> Collections.singletonList(collection.iterator().next());
        } else if (listType != null && listType != this.listType) {
            try {
                list = (Collection)listType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create instance error " + listType, e);
            }
        } else {
            list = (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        int entryCnt = jsonReader.startArray();
        for (int i = 0; i < entryCnt; ++i) {
            list.add(jsonReader.readString());
        }
        if (builder != null) {
            list = builder.apply(list);
        }
        return list;
    }

    public Object readObject(JSONReader jsonReader, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.current() != '[') {
            throw new JSONException("offset " + jsonReader.getOffset() + ", char : " + jsonReader.current());
        }
        jsonReader.next();
        Collection list = (Collection)this.createInstance(jsonReader.getContext().getFeatures() | features);
        while (!jsonReader.nextIfMatch(']')) {
            list.add(jsonReader.readString());
        }
        jsonReader.nextIfMatch(',');
        return list;
    }
}

