/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.FieldWriterInt32Val;
import java.lang.reflect.Field;

final class FieldWriterInt32ValUF<T>
extends FieldWriterInt32Val<T> {
    final long fieldOffset;

    FieldWriterInt32ValUF(String name, int ordinal, long features, String format, Field field) {
        super(name, ordinal, features, format, field);
        this.fieldOffset = UnsafeUtils.objectFieldOffset(field);
    }

    @Override
    public Object getFieldValue(T object) {
        return UnsafeUtils.UNSAFE.getInt(object, this.fieldOffset);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        int value = UnsafeUtils.UNSAFE.getInt(object, this.fieldOffset);
        this.writeInt32(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, Object object) {
        int value = UnsafeUtils.UNSAFE.getInt(object, this.fieldOffset);
        jsonWriter.writeInt32(value);
    }
}

