/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NumberUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.time.LocalTime;

public class IOUtils {
    static final short DOT_ZERO_16 = (short)(JDKUtils.BIG_ENDIAN ? 11824 : 12334);
    static final int DOT_ZERO_32 = JDKUtils.BIG_ENDIAN ? 3014704 : 3145774;
    static final short ZERO_DOT_16 = (short)(JDKUtils.BIG_ENDIAN ? 12334 : 11824);
    static final int ZERO_DOT_32 = JDKUtils.BIG_ENDIAN ? 3145774 : 3014704;
    static final short ZERO_ZERO_16 = 12336;
    static final int ZERO_ZERO_32 = 0x300030;
    static final int NULL_32 = JDKUtils.BIG_ENDIAN ? 1853189228 : 1819047278;
    static final long NULL_64 = JDKUtils.BIG_ENDIAN ? 30962749956423788L : 30399761348886638L;
    static final int TRUE = JDKUtils.BIG_ENDIAN ? 1953658213 : 1702195828;
    static final long TRUE_64 = JDKUtils.BIG_ENDIAN ? 32651586932375653L : 28429475166421108L;
    static final int ALSE = JDKUtils.BIG_ENDIAN ? 1634497381 : 1702063201;
    static final long ALSE_64 = JDKUtils.BIG_ENDIAN ? 27303536604938341L : 28429466576093281L;
    public static final long DOT_X0 = JDKUtils.BIG_ENDIAN ? 11776L : 46L;
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static final int[] DIGITS_K_32 = new int[1024];
    public static final long[] DIGITS_K_64 = new long[1024];
    private static final byte[] MIN_LONG_BYTES = "-9223372036854775808".getBytes();
    private static final char[] MIN_LONG_CHARS = "-9223372036854775808".toCharArray();
    public static final short[] PACKED_DIGITS;
    public static final int[] PACKED_DIGITS_UTF16;
    static final long[] POWER_TEN;
    private static final short ZERO_DOT_LATIN1;

    private static short digitPair(int value) {
        return PACKED_DIGITS[value & 0x7F];
    }

    public static void writeDigitPair(byte[] buf, int charPos, int value) {
        IOUtils.putShortLE(buf, charPos, PACKED_DIGITS[value & 0x7F]);
    }

    public static void writeDigitPair(char[] buf, int charPos, int value) {
        IOUtils.putIntLE(buf, charPos, PACKED_DIGITS_UTF16[value & 0x7F]);
    }

    public static int stringSize(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void getChars(int i, int index, byte[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            int q = i / 100;
            int r = q * 100 - i;
            i = q;
            IOUtils.writeDigitPair(buf, charPos -= 2, r);
        }
        if (i < -9) {
            IOUtils.writeDigitPair(buf, charPos -= 2, -i);
        } else {
            IOUtils.putByte(buf, --charPos, (byte)(48 - i));
        }
        if (negative) {
            IOUtils.putByte(buf, charPos - 1, (byte)45);
        }
    }

    public static void getChars(int i, int index, char[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            int q = i / 100;
            int r = q * 100 - i;
            i = q;
            IOUtils.writeDigitPair(buf, charPos -= 2, r);
        }
        if (i < -9) {
            IOUtils.writeDigitPair(buf, charPos -= 2, -i);
        } else {
            IOUtils.putChar(buf, --charPos, (char)(48 - i));
        }
        if (negative) {
            IOUtils.putChar(buf, charPos - 1, '-');
        }
    }

    public static void getChars(long i, int index, byte[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            IOUtils.writeDigitPair(buf, charPos -= 2, (int)(q * 100L - i));
            i = q;
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q2 = i2 / 100;
            IOUtils.writeDigitPair(buf, charPos -= 2, q2 * 100 - i2);
            i2 = q2;
        }
        if (i2 < -9) {
            IOUtils.writeDigitPair(buf, charPos -= 2, -i2);
        } else {
            IOUtils.putByte(buf, --charPos, (byte)(48 - i2));
        }
        if (negative) {
            IOUtils.putByte(buf, charPos - 1, (byte)45);
        }
    }

    public static void getChars(long i, int index, char[] buf) {
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            IOUtils.writeDigitPair(buf, charPos -= 2, (int)(q * 100L - i));
            i = q;
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            int q2 = i2 / 100;
            IOUtils.writeDigitPair(buf, charPos -= 2, q2 * 100 - i2);
            i2 = q2;
        }
        if (i2 < -9) {
            IOUtils.writeDigitPair(buf, charPos -= 2, -i2);
        } else {
            IOUtils.putChar(buf, --charPos, (char)(48 - i2));
        }
        if (negative) {
            IOUtils.putChar(buf, charPos - 1, '-');
        }
    }

    public static int writeDecimal(byte[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            IOUtils.putByte(buf, off++, (byte)45);
            unscaledVal = -unscaledVal;
        }
        if (scale != 0) {
            int unscaleValSize = IOUtils.stringSize(unscaledVal);
            int insertionPoint = unscaleValSize - scale;
            if (insertionPoint == 0) {
                IOUtils.putShortUnaligned(buf, off, ZERO_DOT_LATIN1);
                off += 2;
            } else if (insertionPoint < 0) {
                IOUtils.putShortUnaligned(buf, off, ZERO_DOT_LATIN1);
                off += 2;
                for (int i = 0; i < -insertionPoint; ++i) {
                    IOUtils.putByte(buf, off++, (byte)48);
                }
            } else {
                long power = POWER_TEN[scale - 1];
                long div = unscaledVal / power;
                long rem = unscaledVal - div * power;
                off = IOUtils.writeInt64(buf, off, div);
                IOUtils.putByte(buf, off, (byte)46);
                if (scale == 1) {
                    IOUtils.putByte(buf, off + 1, (byte)(rem + 48L));
                    return off + 2;
                }
                if (scale == 2) {
                    IOUtils.writeDigitPair(buf, off + 1, (int)rem);
                    return off + 3;
                }
                int end = unscaleValSize - IOUtils.stringSize(rem) - insertionPoint;
                for (int i = 0; i < end; ++i) {
                    IOUtils.putByte(buf, ++off, (byte)48);
                }
                return IOUtils.writeInt64(buf, off + 1, rem);
            }
        }
        return IOUtils.writeInt64(buf, off, unscaledVal);
    }

    public static int writeDecimal(char[] buf, int off, long unscaledVal, int scale) {
        if (unscaledVal < 0L) {
            IOUtils.putChar(buf, off++, '-');
            unscaledVal = -unscaledVal;
        }
        if (scale != 0) {
            int unscaleValSize = IOUtils.stringSize(unscaledVal);
            int insertionPoint = unscaleValSize - scale;
            if (insertionPoint == 0) {
                buf[off++] = 48;
                buf[off++] = 46;
            } else if (insertionPoint < 0) {
                buf[off++] = 48;
                buf[off++] = 46;
                for (int i = 0; i < -insertionPoint; ++i) {
                    IOUtils.putChar(buf, off++, '0');
                }
            } else {
                long power = POWER_TEN[scale - 1];
                long div = unscaledVal / power;
                long rem = unscaledVal - div * power;
                off = IOUtils.writeInt64(buf, off, div);
                IOUtils.putChar(buf, off, '.');
                if (scale == 1) {
                    IOUtils.putChar(buf, off + 1, (char)(rem + 48L));
                    return off + 2;
                }
                if (scale == 2) {
                    IOUtils.writeDigitPair(buf, off + 1, (int)rem);
                    return off + 3;
                }
                int end = unscaleValSize - IOUtils.stringSize(rem) - insertionPoint;
                for (int i = 0; i < end; ++i) {
                    IOUtils.putChar(buf, ++off, '0');
                }
                return IOUtils.writeInt64(buf, off + 1, rem);
            }
        }
        return IOUtils.writeInt64(buf, off, unscaledVal);
    }

    public static int encodeUTF8(byte[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        while (offset < sl) {
            char c = JDKUtils.UNSAFE.getChar(src, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            offset += 2;
            if (c < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                IOUtils.utf8_char2(src, offset, sl, c, dst, dp);
                offset += 2;
                dp += 4;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    public static int encodeUTF8(char[] src, int offset, int len, byte[] dst, int dp) {
        int sl = offset + len;
        int dlASCII = dp + Math.min(len, dst.length);
        while (dp < dlASCII && src[offset] < '\u0080') {
            dst[dp++] = (byte)src[offset++];
        }
        while (offset < sl) {
            char c;
            if ((c = src[offset++]) < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp] = (byte)(0xC0 | c >> 6);
                dst[dp + 1] = (byte)(0x80 | c & 0x3F);
                dp += 2;
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                IOUtils.utf8_char2(src, offset, sl, c, dst, dp);
                ++offset;
                dp += 4;
                continue;
            }
            dst[dp] = (byte)(0xE0 | c >> 12);
            dst[dp + 1] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp + 2] = (byte)(0x80 | c & 0x3F);
            dp += 3;
        }
        return dp;
    }

    private static void utf8_char2(byte[] src, int offset, int sl, char c, byte[] dst, int dp) {
        char d;
        if (c > '\udbff' || sl - offset < 1 || (d = JDKUtils.UNSAFE.getChar(src, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset)) < '\udc00' || d > '\udfff') {
            throw new JSONException("malformed input off : " + offset);
        }
        int uc = (c << 10) + d + -56613888;
        dst[dp] = (byte)(0xF0 | uc >> 18);
        dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
        dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
        dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
    }

    private static void utf8_char2(char[] src, int offset, int sl, char c, byte[] dst, int dp) {
        char d;
        if (c > '\udbff' || sl - offset < 1 || (d = src[offset]) < '\udc00' || d > '\udfff') {
            throw new JSONException("malformed input off : " + offset);
        }
        int uc = (c << 10) + d + -56613888;
        dst[dp] = (byte)(0xF0 | uc >> 18);
        dst[dp + 1] = (byte)(0x80 | uc >> 12 & 0x3F);
        dst[dp + 2] = (byte)(0x80 | uc >> 6 & 0x3F);
        dst[dp + 3] = (byte)(0x80 | uc & 0x3F);
    }

    public static boolean isNumber(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 || len == 1 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(char[] buf, int off, int len) {
        if (len <= 0) {
            return false;
        }
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = buf[i];
            if (!(ch == '+' || ch == '-' ? i != off || len == 1 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(byte[] buf, int off, int len) {
        if (len <= 0) {
            return false;
        }
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char ch = (char)buf[i];
            if (!(ch == '+' || ch == '-' ? i != off || len == 1 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int decodeUTF8(byte[] src, int off, int len, byte[] dst) {
        int sl = off + len;
        int dp = 0;
        while (off < sl) {
            byte b1;
            byte b0;
            if ((b0 = src[off++]) >= 0) {
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                continue;
            }
            if (b0 >> 5 == -2 && (b0 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b1 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 6 ^ b1 ^ 0xF80);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                dst[dp] = b0;
                dst[dp + 1] = 0;
                dp += 2;
                break;
            }
            if (b0 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b1 = src[off];
                    byte b2 = src[off + 1];
                    off += 2;
                    if (b0 == -32 && (b1 & 0xE0) == 128 || (b1 & 0xC0) != 128 || (b2 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b0 << 12 ^ b1 << 6 ^ (b2 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            if (b0 >> 3 == -2) {
                if (off + 2 < sl) {
                    byte b2 = src[off];
                    byte b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b0 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    char c = (char)((uc >>> 10) + 55232);
                    dst[dp] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    c = (char)((uc & 0x3FF) + 56320);
                    dst[dp += 2] = (byte)c;
                    dst[dp + 1] = (byte)(c >> 8);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static int decodeUTF8(byte[] src, int off, int len, char[] dst) {
        int sl = off + len;
        int dp = 0;
        int dlASCII = Math.min(len, dst.length);
        while (dp < dlASCII && src[off] >= 0) {
            dst[dp++] = (char)src[off++];
        }
        while (off < sl) {
            byte b3;
            byte b2;
            byte b1;
            if ((b1 = src[off++]) >= 0) {
                dst[dp++] = (char)b1;
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (off < sl) {
                    if (((b2 = src[off++]) & 0xC0) != 128) {
                        return -1;
                    }
                    dst[dp++] = (char)(b1 << 6 ^ b2 ^ 0xF80);
                    continue;
                }
                return -1;
            }
            if (b1 >> 4 == -2) {
                if (off + 1 < sl) {
                    boolean isSurrogate;
                    b2 = src[off];
                    b3 = src[off + 1];
                    off += 2;
                    if (b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        return -1;
                    }
                    char c = (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
                    boolean bl = isSurrogate = c >= '\ud800' && c < '\ue000';
                    if (isSurrogate) {
                        return -1;
                    }
                    dst[dp++] = c;
                    continue;
                }
                return -1;
            }
            if (b1 >> 3 == -2) {
                if (off + 2 < sl) {
                    b2 = src[off];
                    b3 = src[off + 1];
                    byte b4 = src[off + 2];
                    off += 3;
                    int uc = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                        return -1;
                    }
                    dst[dp] = (char)((uc >>> 10) + 55232);
                    dst[dp + 1] = (char)((uc & 0x3FF) + 56320);
                    dp += 2;
                    continue;
                }
                return -1;
            }
            return -1;
        }
        return dp;
    }

    public static long lines(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            long l = IOUtils.lines(in);
            return l;
        }
    }

    public static long lines(InputStream in) throws Exception {
        int len;
        long lines = 0L;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            int i = 0;
            long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET;
            int upperBound = len & 0xFFFFFFF8;
            while (i < upperBound && IOUtils.notContains(JDKUtils.UNSAFE.getLong(buf, address), 0xA0A0A0A0A0A0A0AL)) {
                i += 8;
                address += 8L;
            }
            while (i < len) {
                byte b = buf[i];
                if (b == 10) {
                    ++lines;
                }
                ++i;
            }
        }
        return lines;
    }

    public static int writeLocalDate(byte[] buf, int off, int year, int month, int dayOfMonth) {
        if (year < 0) {
            buf[off++] = 45;
            year = -year;
        } else if (year > 9999) {
            buf[off++] = 43;
        }
        int y01 = (int)((long)year * 1374389535L >> 37);
        int y23 = year - y01 * 100;
        if (year >= 0 && year < 10000) {
            IOUtils.writeDigitPair(buf, off, y01);
            off += 2;
        } else {
            off = IOUtils.writeInt32(buf, off, (long)y01);
        }
        IOUtils.putLongLE(buf, off, 0x2D00002D0000L | (long)IOUtils.digitPair(y23) | (long)IOUtils.digitPair(month) << 24 | (long)IOUtils.digitPair(dayOfMonth) << 48);
        return off + 8;
    }

    public static int writeLocalDate(char[] buf, int off, int year, int month, int dayOfMonth) {
        if (year < 0) {
            buf[off++] = 45;
            year = -year;
        } else if (year > 9999) {
            buf[off++] = 43;
        }
        int y01 = (int)((long)year * 1374389535L >> 37);
        int y23 = year - y01 * 100;
        if (year >= 0 && year < 10000) {
            IOUtils.writeDigitPair(buf, off, y01);
            off += 2;
        } else {
            off = IOUtils.writeInt32(buf, off, (long)y01);
        }
        int p1 = PACKED_DIGITS_UTF16[month & 0x7F];
        IOUtils.putLongLE(buf, off, (long)(p1 & 0xFFFF) << 48 | 0x2D00000000L | (long)PACKED_DIGITS_UTF16[y23 & 0x7F]);
        IOUtils.putLongLE(buf, off + 4, (long)(p1 & 0xFFFF0000) >> 16 | 0x2D0000L | (long)PACKED_DIGITS_UTF16[dayOfMonth & 0x7F] << 32);
        return off + 8;
    }

    public static void writeLocalTime(byte[] buf, int off, int hour, int minute, int second) {
        IOUtils.putLongLE(buf, off, 0x3A00003A0000L | (long)IOUtils.digitPair(hour) | (long)IOUtils.digitPair(minute) << 24 | (long)IOUtils.digitPair(second) << 48);
    }

    public static int writeLocalTime(byte[] buf, int off, LocalTime time) {
        IOUtils.writeLocalTime(buf, off, time.getHour(), time.getMinute(), time.getSecond());
        int nano = time.getNano();
        return nano != 0 ? IOUtils.writeNano(buf, off, nano) : (off += 8);
    }

    public static int writeNano(byte[] buf, int off, int nano) {
        int v;
        int div = (int)((long)nano * 274877907L >> 38);
        int div2 = (int)((long)div * 274877907L >> 38);
        int rem1 = nano - div * 1000;
        IOUtils.putIntLE(buf, off, DIGITS_K_32[div2 & 0x3FF] & 0xFFFFFF00 | 0x2E);
        off += 4;
        if (rem1 == 0) {
            int rem2 = div - div2 * 1000;
            if (rem2 == 0) {
                return off;
            }
            v = DIGITS_K_32[rem2 & 0x3FF];
        } else {
            v = DIGITS_K_32[div - div2 * 1000 & 0x3FF];
        }
        IOUtils.putShortLE(buf, off, (short)(v >> 8));
        off += 2;
        if (rem1 == 0) {
            IOUtils.putByte(buf, off, (byte)(v >> 24));
            return off + 1;
        }
        IOUtils.putIntLE(buf, off, DIGITS_K_32[rem1] & 0xFFFFFF00 | v >> 24);
        return off + 4;
    }

    public static int writeNano(char[] buf, int off, int nano) {
        long v;
        int div = (int)((long)nano * 274877907L >> 38);
        int div2 = (int)((long)div * 274877907L >> 38);
        int rem1 = nano - div * 1000;
        IOUtils.putLongLE(buf, off, DIGITS_K_64[div2 & 0x3FF] & 0xFFFFFFFFFFFF0000L | DOT_X0);
        off += 4;
        if (rem1 == 0) {
            int rem2 = div - div2 * 1000;
            if (rem2 == 0) {
                return off;
            }
            v = DIGITS_K_64[rem2 & 0x3FF];
        } else {
            v = DIGITS_K_64[div - div2 * 1000 & 0x3FF];
        }
        IOUtils.putIntLE(buf, off, (int)(v >> 16));
        off += 2;
        if (rem1 == 0) {
            IOUtils.putChar(buf, off, (char)(v >> 48));
            return off + 1;
        }
        IOUtils.putLongLE(buf, off, DIGITS_K_64[rem1 & 0x3FF] & 0xFFFFFFFFFFFF0000L | v >> 48);
        return off + 4;
    }

    public static void writeLocalTime(char[] buf, int off, int hour, int minute, int second) {
        IOUtils.writeDigitPair(buf, off, hour);
        IOUtils.putChar(buf, off + 2, ':');
        IOUtils.writeDigitPair(buf, off + 3, minute);
        IOUtils.putChar(buf, off + 5, ':');
        IOUtils.writeDigitPair(buf, off + 6, second);
    }

    public static int writeLocalTime(char[] buf, int off, LocalTime time) {
        IOUtils.writeLocalTime(buf, off, time.getHour(), time.getMinute(), time.getSecond());
        int nano = time.getNano();
        return nano != 0 ? IOUtils.writeNano(buf, off, nano) : (off += 8);
    }

    private static int writeInt4(byte[] buf, int off, int v) {
        int v1 = (int)((long)v * 1374389535L >> 37);
        int v0 = v - v1 * 100;
        int v2 = PACKED_DIGITS[v1 & 0x7F] | PACKED_DIGITS[v0 & 0x7F] << 16;
        if (JDKUtils.BIG_ENDIAN) {
            v2 = Integer.reverseBytes(v2);
        }
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, v2);
        return off + 4;
    }

    private static int writeInt4(char[] buf, int off, int v) {
        int v1 = (int)((long)v * 1374389535L >> 37);
        IOUtils.putLongUnaligned(buf, off, IOUtils.mergeInt64(v - v1 * 100, v1));
        return off + 4;
    }

    private static long mergeInt64(int v1, int v2) {
        long v = (long)PACKED_DIGITS_UTF16[v2 & 0x7F] | (long)PACKED_DIGITS_UTF16[v1 & 0x7F] << 32;
        if (JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    private static int writeInt3(byte[] buf, int off, int val) {
        int v = DIGITS_K_32[val & 0x3FF];
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, v >> ((byte)v + 1 << 3));
        return off + 3 - (byte)v;
    }

    private static int writeInt3(char[] buf, int off, int val) {
        long v = DIGITS_K_64[val & 0x3FF];
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1), v >> ((short)v + 1 << 4));
        return off + 3 - (byte)v;
    }

    private static int writeInt8(byte[] buf, int off, int v1, int v2) {
        int r1 = (int)((long)v1 * 1374389535L >> 37);
        int r2 = (int)((long)v2 * 1374389535L >> 37);
        long v = (long)(PACKED_DIGITS[r1 & 0x7F] | PACKED_DIGITS[v1 - r1 * 100 & 0x7F] << 16) | (long)PACKED_DIGITS[r2 & 0x7F] << 32 | (long)PACKED_DIGITS[v2 - r2 * 100 & 0x7F] << 48;
        if (JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off, v);
        return off + 8;
    }

    private static int writeInt8(char[] buf, int off, int v1, int v2) {
        int r1 = (int)((long)v1 * 1374389535L >> 37);
        long x1 = (long)PACKED_DIGITS_UTF16[r1 & 0x7F] | (long)PACKED_DIGITS_UTF16[v1 - r1 * 100 & 0x7F] << 32;
        int r2 = (int)((long)v2 * 1374389535L >> 37);
        long x2 = (long)PACKED_DIGITS_UTF16[r2 & 0x7F] | (long)PACKED_DIGITS_UTF16[v2 - r2 * 100 & 0x7F] << 32;
        if (JDKUtils.BIG_ENDIAN) {
            x1 = Long.reverseBytes(x1);
            x2 = Long.reverseBytes(x2);
        }
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1), x1);
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1) + 8L, x2);
        return off + 8;
    }

    public static int writeInt64(byte[] buf, int off, long val) {
        if (val < 0L) {
            if (val == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG_BYTES, 0, buf, off, MIN_LONG_BYTES.length);
                return off + MIN_LONG_BYTES.length;
            }
            val = -val;
            IOUtils.putByte(buf, off++, (byte)45);
        }
        if (val <= Integer.MAX_VALUE) {
            return IOUtils.writeInt32(buf, off, (long)((int)val));
        }
        long numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 7555786372591432342L) >> 12;
        int v1 = (int)(numValue - val * 10000L);
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? IOUtils.writeInt3(buf, off, v) : IOUtils.writeInt4(buf, off, v);
            return IOUtils.writeInt8(buf, off, v2, v1);
        }
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off = IOUtils.writeInt3(buf, off, v);
                off = IOUtils.writeInt4(buf, off, v3);
            } else {
                IOUtils.writeInt8(buf, off, v, v3);
                off += 8;
            }
            return IOUtils.writeInt8(buf, off, v2, v1);
        }
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v4 = (int)(numValue - val * 10000L);
        off = IOUtils.writeInt3(buf, off, (int)val);
        off = IOUtils.writeInt8(buf, off, v4, v3);
        return IOUtils.writeInt8(buf, off, v2, v1);
    }

    public static int writeInt64(char[] buf, int off, long val) {
        if (val < 0L) {
            if (val == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG_CHARS, 0, buf, off, MIN_LONG_CHARS.length);
                return off + MIN_LONG_CHARS.length;
            }
            val = -val;
            IOUtils.putChar(buf, off++, '-');
        }
        if (val <= Integer.MAX_VALUE) {
            return IOUtils.writeInt32(buf, off, (long)((int)val));
        }
        long numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 7555786372591432342L) >> 12;
        int v1 = (int)(numValue - val * 10000L);
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v2 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? IOUtils.writeInt3(buf, off, v) : IOUtils.writeInt4(buf, off, v);
            return IOUtils.writeInt8(buf, off, v2, v1);
        }
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v3 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off = IOUtils.writeInt3(buf, off, v);
                off = IOUtils.writeInt4(buf, off, v3);
            } else {
                IOUtils.writeInt8(buf, off, v, v3);
                off += 8;
            }
            return IOUtils.writeInt8(buf, off, v2, v1);
        }
        numValue = val;
        val = NumberUtils.MULTIPLY_HIGH.multiplyHigh(numValue, 1844674407370956L);
        int v4 = (int)(numValue - val * 10000L);
        off = IOUtils.writeInt3(buf, off, (int)val);
        off = IOUtils.writeInt8(buf, off, v4, v3);
        return IOUtils.writeInt8(buf, off, v2, v1);
    }

    public static int writeInt8(byte[] buf, int pos, byte value) {
        byte i;
        if (value < 0) {
            i = -value;
            IOUtils.putByte(buf, pos++, (byte)45);
        } else {
            i = value;
        }
        int v = DIGITS_K_32[i & 0x3FF];
        byte start = (byte)v;
        if (start == 0) {
            IOUtils.putShortLE(buf, pos, (short)(v >> 8));
            pos += 2;
        } else if (start == 1) {
            IOUtils.putByte(buf, pos++, (byte)(v >> 16));
        }
        IOUtils.putByte(buf, pos, (byte)(v >> 24));
        return pos + 1;
    }

    public static int writeInt8(char[] buf, int pos, byte value) {
        byte i;
        if (value < 0) {
            i = -value;
            IOUtils.putChar(buf, pos++, '-');
        } else {
            i = value;
        }
        long v = DIGITS_K_64[i & 0x3FF];
        byte start = (byte)v;
        if (start == 0) {
            IOUtils.putIntLE(buf, pos, (int)(v >> 16));
            pos += 2;
        } else if (start == 1) {
            IOUtils.putChar(buf, pos++, (char)(v >> 32));
        }
        IOUtils.putChar(buf, pos, (char)(v >> 48));
        return pos + 1;
    }

    public static int writeInt16(byte[] buf, int pos, short value) {
        short i;
        if (value < 0) {
            i = -value;
            IOUtils.putByte(buf, pos++, (byte)45);
        } else {
            i = value;
        }
        if (i < 1000) {
            int v = DIGITS_K_32[i & 0x3FF];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putShortLE(buf, pos, (short)(v >> 8));
                pos += 2;
            } else if (start == 1) {
                IOUtils.putByte(buf, pos++, (byte)(v >> 16));
            }
            IOUtils.putByte(buf, pos, (byte)(v >> 24));
            return pos + 1;
        }
        int q1 = (int)((long)i * 274877907L >> 38);
        int v2 = DIGITS_K_32[q1 & 0x3FF];
        if ((byte)v2 == 1) {
            IOUtils.putByte(buf, pos++, (byte)(v2 >> 16));
        }
        IOUtils.putIntLE(buf, pos, DIGITS_K_32[i - q1 * 1000 & 0x3FF] & 0xFFFFFF00 | v2 >> 24);
        return pos + 4;
    }

    public static int writeInt16(char[] buf, int pos, short value) {
        short i;
        if (value < 0) {
            i = -value;
            IOUtils.putChar(buf, pos++, '-');
        } else {
            i = value;
        }
        if (i < 1000) {
            long v = DIGITS_K_64[i & 0x3FF];
            byte start = (byte)v;
            if (start == 0) {
                IOUtils.putIntLE(buf, pos, (int)(v >> 16));
                pos += 2;
            } else if (start == 1) {
                IOUtils.putChar(buf, pos++, (char)(v >> 32));
            }
            IOUtils.putChar(buf, pos, (char)(v >> 48));
            return pos + 1;
        }
        int q1 = (int)((long)i * 274877907L >> 38);
        long v2 = DIGITS_K_64[q1 & 0x3FF];
        if ((byte)v2 == 1) {
            IOUtils.putChar(buf, pos++, (char)(v2 >> 32));
        }
        IOUtils.putLongLE(buf, pos, DIGITS_K_64[i - q1 * 1000 & 0x3FF] & 0xFFFFFFFFFFFF0000L | v2 >> 48);
        return pos + 4;
    }

    public static int writeInt32(byte[] buf, int off, long val) {
        if (val < 0L) {
            val = -val;
            IOUtils.putByte(buf, off++, (byte)45);
        }
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? IOUtils.writeInt3(buf, off, v) : IOUtils.writeInt4(buf, off, v);
            return off;
        }
        long numValue = val;
        val = (int)(numValue * 1759218605L >> 44);
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off = IOUtils.writeInt3(buf, off, v);
                off = IOUtils.writeInt4(buf, off, v1);
            } else {
                off = IOUtils.writeInt8(buf, off, v, v1);
            }
            return off;
        }
        numValue = val;
        val = (int)(numValue * 1759218605L >> 44);
        off = IOUtils.writeInt3(buf, off, (int)val);
        return IOUtils.writeInt8(buf, off, (int)(numValue - val * 10000L), v1);
    }

    public static int writeInt32(char[] buf, int off, long val) {
        if (val < 0L) {
            val = -val;
            IOUtils.putChar(buf, off++, '-');
        }
        if (val < 10000L) {
            int v = (int)val;
            off = v < 1000 ? IOUtils.writeInt3(buf, off, v) : IOUtils.writeInt4(buf, off, v);
            return off;
        }
        long numValue = val;
        val = (int)(numValue * 1759218605L >> 44);
        int v1 = (int)(numValue - val * 10000L);
        if (val < 10000L) {
            int v = (int)val;
            if (v < 1000) {
                off = IOUtils.writeInt3(buf, off, v);
                off = IOUtils.writeInt4(buf, off, v1);
            } else {
                off = IOUtils.writeInt8(buf, off, v, v1);
            }
            return off;
        }
        numValue = val;
        val = (int)(numValue * 1759218605L >> 44);
        off = IOUtils.writeInt3(buf, off, (int)val);
        return IOUtils.writeInt8(buf, off, (int)(numValue - val * 10000L), v1);
    }

    public static byte getByte(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getByte(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos);
    }

    public static char getChar(char[] buf, int pos) {
        return JDKUtils.UNSAFE.getChar(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1));
    }

    public static char getChar(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getChar(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + ((long)pos << 1));
    }

    private static void putByte(byte[] buf, int pos, byte v) {
        JDKUtils.UNSAFE.putByte(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    private static void putChar(char[] buf, int pos, char v) {
        JDKUtils.UNSAFE.putChar(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), v);
    }

    public static void putShortBE(byte[] buf, int pos, short v) {
        JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, IOUtils.convEndian(true, v));
    }

    public static void putShortLE(byte[] buf, int pos, short v) {
        JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, IOUtils.convEndian(false, v));
    }

    public static void putIntBE(byte[] buf, int pos, int v) {
        if (!JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    public static void putIntLE(byte[] buf, int pos, int v) {
        if (JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    public static void putIntLE(char[] buf, int pos, int v) {
        if (JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), v);
    }

    public static void putShortUnaligned(byte[] buf, int pos, short v) {
        JDKUtils.UNSAFE.putShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    public static void putIntUnaligned(char[] buf, int pos, int v) {
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), v);
    }

    public static void putIntUnaligned(byte[] buf, int pos, int v) {
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    public static void putLongLE(char[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), IOUtils.convEndian(false, v));
    }

    public static void putLongUnaligned(char[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), v);
    }

    public static void putLongUnaligned(byte[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, v);
    }

    public static void putLongBE(byte[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, IOUtils.convEndian(true, v));
    }

    public static void putLongLE(byte[] buf, int pos, long v) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, IOUtils.convEndian(false, v));
    }

    public static int putBoolean(byte[] buf, int off, boolean v) {
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off;
        if (v) {
            JDKUtils.UNSAFE.putInt(buf, address, TRUE);
            return off + 4;
        }
        JDKUtils.UNSAFE.putByte(buf, address, (byte)102);
        JDKUtils.UNSAFE.putInt(buf, address + 1L, ALSE);
        return off + 5;
    }

    public static int putBoolean(char[] buf, int off, boolean v) {
        long address = JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1);
        if (v) {
            JDKUtils.UNSAFE.putLong(buf, address, TRUE_64);
            return off + 4;
        }
        JDKUtils.UNSAFE.putChar(buf, address, 'f');
        JDKUtils.UNSAFE.putLong(buf, address + 2L, ALSE_64);
        return off + 5;
    }

    public static boolean isALSE(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos) == ALSE;
    }

    public static boolean notALSE(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos) != ALSE;
    }

    public static boolean isALSE(char[] buf, int pos) {
        return IOUtils.getLongUnaligned(buf, pos) == ALSE_64;
    }

    public static boolean notALSE(char[] buf, int pos) {
        return IOUtils.getLongUnaligned(buf, pos) != ALSE_64;
    }

    public static boolean isNULL(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos) == NULL_32;
    }

    public static boolean notNULL(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos) != NULL_32;
    }

    public static boolean notTRUE(byte[] buf, int pos) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos) != TRUE;
    }

    public static boolean notTRUE(char[] buf, int pos) {
        return JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1)) != TRUE_64;
    }

    public static boolean isNULL(char[] buf, int pos) {
        return IOUtils.getLongUnaligned(buf, pos) == NULL_64;
    }

    public static boolean notNULL(char[] buf, int pos) {
        return IOUtils.getLongUnaligned(buf, pos) != NULL_64;
    }

    public static void putNULL(byte[] buf, int pos) {
        JDKUtils.UNSAFE.putInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)pos, NULL_32);
    }

    public static void putNULL(char[] buf, int pos) {
        JDKUtils.UNSAFE.putLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)pos << 1), NULL_64);
    }

    public static int digit4(char[] buf, int off) {
        long d;
        long x = IOUtils.getLongLE(buf, off);
        if (((x & 0xFFF0FFF0FFF0FFF0L) - 0x30003000300030L | (d = x & 0xF000F000F000FL) + 0x6000600060006L & 0xF000F000F000F0L) != 0L) {
            return -1;
        }
        return (int)((((d & 0xFL) * 10L + (d >> 16 & 0xFL)) * 10L + (d >> 32 & 0xFL)) * 10L + (d >> 48));
    }

    public static int digit4(byte[] buf, int off) {
        return IOUtils.digit4(IOUtils.getIntLE(buf, off));
    }

    private static int digit4(int x) {
        int d = x & 0xF0F0F0F;
        if (((x & 0xF0F0F0F0) - 0x30303030 | d + 0x6060606 & 0xF0F0F0F0) != 0) {
            return -1;
        }
        return (((d & 0xF) * 10 + (d >> 8 & 0xF)) * 10 + (d >> 16 & 0xF)) * 10 + (d >> 24);
    }

    public static int digit3(char[] buf, int off) {
        long d;
        long x = (long)IOUtils.getIntLE(buf, off) + ((long)IOUtils.getChar(buf, off + 2) << 32);
        if (((x & 0xFFF0FFF0FFF0L) - 0x3000300030L | (d = x & 0xF000F000FL) + 0x600060006L & 0xF000F000F0L) != 0L) {
            return -1;
        }
        return (int)(((d & 0xFL) * 10L + (d >> 16 & 0xFL)) * 10L + (d >> 32));
    }

    public static int digit3(byte[] buf, int off) {
        return IOUtils.digit3(IOUtils.getShortLE(buf, off) | IOUtils.getByte(buf, off + 2) << 16);
    }

    private static int digit3(int x) {
        int d = x & 0xF0F0F;
        if (((x & 0xF0F0F0) - 0x303030 | d + 394758 & 0xF0F0F0) != 0) {
            return -1;
        }
        return ((d & 0xF) * 10 + (d >> 8 & 0xF)) * 10 + (d >> 16);
    }

    public static int digit2(char[] buf, int off) {
        int d;
        int x = JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1));
        if (JDKUtils.BIG_ENDIAN) {
            x = Integer.reverseBytes(x);
        }
        if (((x & 0xFFF0FFF0) - 0x300030 | (d = x & 0xF000F) + 393222 & 0xF000F0) != 0) {
            return -1;
        }
        return (d & 0xF) * 10 + (d >> 16);
    }

    public static int digit2(byte[] buf, int off) {
        int d;
        short x = JDKUtils.UNSAFE.getShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off);
        if (JDKUtils.BIG_ENDIAN) {
            x = Short.reverseBytes(x);
        }
        if (((x & 0xF0F0) - 12336 | (d = x & 0xF0F) + 1542 & 0xF0F0) != 0) {
            return -1;
        }
        return (d & 0xF) * 10 + (d >> 8);
    }

    public static boolean isDigit2(char[] buf, int off) {
        int x = JDKUtils.UNSAFE.getShort(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1));
        if (JDKUtils.BIG_ENDIAN) {
            x = Integer.reverseBytes(x);
        }
        return ((x & 0xFFF0FFF0) - 0x300030 | (x & 0xF000F) + 393222 & 0xF000F0) == 0;
    }

    public static int digit(int d) {
        return d >= 0 && d <= 9 ? d : -1;
    }

    public static int digit1(char[] buf, int off) {
        int d = JDKUtils.UNSAFE.getByte(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1)) - 48;
        return d >= 0 && d <= 9 ? d : -1;
    }

    public static int digit1(byte[] buf, int off) {
        int d = JDKUtils.UNSAFE.getByte(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off) - 48;
        return d >= 0 && d <= 9 ? d : -1;
    }

    public static int indexOfQuote(byte[] buf, int quote, int fromIndex, int max) {
        if (JDKUtils.INDEX_OF_CHAR_LATIN1 == null) {
            return IOUtils.indexOfQuoteV(buf, quote, fromIndex, max);
        }
        try {
            return JDKUtils.INDEX_OF_CHAR_LATIN1.invokeExact(buf, quote, fromIndex, max);
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage());
        }
    }

    public static int indexOfQuoteV(byte[] buf, int quote, int fromIndex, int max) {
        long vectorQuote;
        int i = fromIndex;
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)fromIndex;
        int upperBound = fromIndex + (max - fromIndex & 0xFFFFFFF8);
        long l = vectorQuote = quote == 39 ? 0x2727272727272727L : 0x2222222222222222L;
        while (i < upperBound && IOUtils.notContains(JDKUtils.UNSAFE.getLong(buf, address), vectorQuote)) {
            i += 8;
            address += 8L;
        }
        return IOUtils.indexOfChar(buf, quote, i, max);
    }

    public static int indexOfDoubleQuote(byte[] buf, int fromIndex, int max) {
        if (JDKUtils.INDEX_OF_CHAR_LATIN1 == null) {
            return IOUtils.indexOfDoubleQuoteV(buf, fromIndex, max);
        }
        try {
            return JDKUtils.INDEX_OF_CHAR_LATIN1.invokeExact(buf, 34, fromIndex, max);
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage());
        }
    }

    public static int indexOfDoubleQuoteV(byte[] buf, int fromIndex, int max) {
        int i = fromIndex;
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)fromIndex;
        int upperBound = fromIndex + (max - fromIndex & 0xFFFFFFF8);
        while (i < upperBound && IOUtils.notContains(JDKUtils.UNSAFE.getLong(buf, address), 0x2222222222222222L)) {
            i += 8;
            address += 8L;
        }
        return IOUtils.indexOfChar(buf, 34, i, max);
    }

    public static int indexOfLineSeparator(byte[] buf, int fromIndex, int max) {
        if (JDKUtils.INDEX_OF_CHAR_LATIN1 == null) {
            return IOUtils.indexOfLineSeparatorV(buf, fromIndex, max);
        }
        try {
            return JDKUtils.INDEX_OF_CHAR_LATIN1.invokeExact(buf, 10, fromIndex, max);
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage());
        }
    }

    public static int indexOfLineSeparatorV(byte[] buf, int fromIndex, int max) {
        int i = fromIndex;
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)fromIndex;
        int upperBound = fromIndex + (max - fromIndex & 0xFFFFFFF8);
        while (i < upperBound && IOUtils.notContains(JDKUtils.UNSAFE.getLong(buf, address), 0xA0A0A0A0A0A0A0AL)) {
            i += 8;
            address += 8L;
        }
        return IOUtils.indexOfChar(buf, 10, i, max);
    }

    public static int indexOfSlash(byte[] buf, int fromIndex, int max) {
        if (JDKUtils.INDEX_OF_CHAR_LATIN1 == null) {
            return IOUtils.indexOfSlashV(buf, fromIndex, max);
        }
        try {
            return JDKUtils.INDEX_OF_CHAR_LATIN1.invokeExact(buf, 92, fromIndex, max);
        }
        catch (Throwable e) {
            throw new JSONException(e.getMessage());
        }
    }

    public static int indexOfSlashV(byte[] buf, int fromIndex, int max) {
        int i = fromIndex;
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)fromIndex;
        int upperBound = fromIndex + (max - fromIndex & 0xFFFFFFF8);
        while (i < upperBound && IOUtils.notContains(JDKUtils.UNSAFE.getLong(buf, address), 0x5C5C5C5C5C5C5C5CL)) {
            i += 8;
            address += 8L;
        }
        return IOUtils.indexOfChar(buf, 92, i, max);
    }

    public static boolean regionMatches(byte[] bytes, int off, String prefix) {
        int len = prefix.length();
        if (off + len >= bytes.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[off + i] == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int indexOfChar(byte[] buf, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (buf[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfChar(char[] buf, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (buf[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static boolean notContains(long value, long vector) {
        long x = value ^ vector;
        return (x - 0x101010101010101L & (x ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) == 0L;
    }

    public static int hexDigit4(byte[] buf, int offset) {
        int v = IOUtils.getIntLE(buf, offset);
        v = (v & 0xF0F0F0F) + (((v & 0x40404040) >> 2 | (v & 0x40404040) << 1) >>> 4);
        return ((v & 0xF000000) >>> 24) + ((v & 0xF0000) >>> 12) + (v & 0xF00) + ((v & 0xF) << 12);
    }

    public static int hexDigit4(char[] buf, int offset) {
        long v = IOUtils.getLongLE(buf, offset);
        v = (v & 0xF000F000F000FL) + (((v & 0x40004000400040L) >> 2 | (v & 0x40004000400040L) << 1) >>> 4);
        return (int)(((v & 0xF000000000000L) >>> 48) + ((v & 0xF00000000L) >>> 28) + ((v & 0xF0000L) >> 8) + ((v & 0xFL) << 12));
    }

    public static boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static short getShortUnaligned(byte[] buf, int offset) {
        return JDKUtils.UNSAFE.getShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    public static short getShortBE(byte[] buf, int offset) {
        return IOUtils.convEndian(true, JDKUtils.UNSAFE.getShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset));
    }

    public static short getShortLE(byte[] buf, int offset) {
        return IOUtils.convEndian(false, JDKUtils.UNSAFE.getShort(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset));
    }

    public static boolean isUTF8BOM(byte[] buf, int off) {
        return (IOUtils.getIntLE(buf, off) & 0xFFFFFF) == 0xBFBBEF;
    }

    public static int getIntBE(byte[] buf, int offset) {
        int v = JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
        if (!JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    public static int getIntLE(byte[] buf, int offset) {
        int v = JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
        if (JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    public static int getIntLE(char[] buf, int offset) {
        int v = JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)offset << 1));
        if (JDKUtils.BIG_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    public static int getIntUnaligned(byte[] buf, int offset) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    public static int getIntUnaligned(char[] buf, int offset) {
        return JDKUtils.UNSAFE.getInt(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)offset << 1));
    }

    public static long getLongBE(byte[] buf, int offset) {
        long v = JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
        if (!JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    public static long getLongUnaligned(byte[] buf, int offset) {
        return JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    public static long getLongUnaligned(char[] buf, int offset) {
        return JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)offset << 1));
    }

    public static long getLongLE(byte[] buf, int offset) {
        return IOUtils.convEndian(false, JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset));
    }

    public static long getLongLE(char[] buf, int offset) {
        long v = JDKUtils.UNSAFE.getLong(buf, JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)offset << 1));
        if (JDKUtils.BIG_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    public static short hex2(int i) {
        i = (i & 0xF0) >> 4 | (i & 0xF) << 8;
        int m = i + 0x6060606 & 0x10101010;
        return (short)((m << 1) + (m >> 1) - (m >> 4) + 0x30303030 + i);
    }

    public static short hex2U(int i) {
        i = (i & 0xF0) >> 4 | (i & 0xF) << 8;
        int m = i + 0x6060606 & 0x10101010;
        return (short)((m >> 1) - (m >> 4) + 0x30303030 + i);
    }

    public static int utf16Hex2(int i) {
        i = (i & 0xF0) >> 4 | (i & 0xF) << 16;
        int m = i + 393222 & 0x100010;
        return (m << 1) + (m >> 1) - (m >> 4) + 0x300030 + i;
    }

    public static int hex4U(int i) {
        i = IOUtils.reverseBytesExpand(i);
        int m = i + 0x6060606 & 0x10101010;
        return (m * 7 >> 4) + 0x30303030 + i;
    }

    public static long utf16Hex4U(long i) {
        i = IOUtils.utf16ReverseBytesExpand(i);
        long m = i + 0x6000600060006L & 0x10001000100010L;
        return (m >> 1) - (m >> 4) + 0x30003000300030L + i;
    }

    private static int reverseBytesExpand(int i) {
        return (i & 0xF000) >> 12 | i & 0xF00 | (i & 0xF0) << 12 | (i & 0xF) << 24;
    }

    private static long utf16ReverseBytesExpand(long i) {
        return (i & 0xF000L) >> 12 | (i & 0xF00L) << 8 | (i & 0xF0L) << 28 | (i & 0xFL) << 48;
    }

    public static int convEndian(boolean big, int n) {
        return big == JDKUtils.BIG_ENDIAN ? n : Integer.reverseBytes(n);
    }

    public static long convEndian(boolean big, long n) {
        return big == JDKUtils.BIG_ENDIAN ? n : Long.reverseBytes(n);
    }

    static short convEndian(boolean big, short n) {
        return big == JDKUtils.BIG_ENDIAN ? n : Short.reverseBytes(n);
    }

    public static boolean isLatin1(char[] buf, int off, int len) {
        int end = off + len;
        int upperBound = off + (len & 0xFFFFFFF8);
        long address = JDKUtils.ARRAY_CHAR_BASE_OFFSET + ((long)off << 1);
        while (off < upperBound && (IOUtils.convEndian(false, JDKUtils.UNSAFE.getLong(buf, address) | JDKUtils.UNSAFE.getLong(buf, address + 8L)) & 0xFF00FF00FF00FF00L) == 0L) {
            address += 16L;
            off += 8;
        }
        while (off++ < end) {
            if ((IOUtils.convEndian(false, JDKUtils.UNSAFE.getShort(buf, address)) & 0xFF00) != 0) {
                return false;
            }
            address += 2L;
        }
        return true;
    }

    public static boolean isASCII(String str) {
        if (JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER != null) {
            return JDKUtils.STRING_CODER.applyAsInt(str) == 0 && IOUtils.isASCII(JDKUtils.STRING_VALUE.apply(str));
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isASCII(byte[] buf) {
        return IOUtils.isASCII(buf, 0, buf.length);
    }

    public static boolean isASCII(byte[] buf, int off, int len) {
        int end = off + len;
        int upperBound = off + (len & 0xFFFFFFF8);
        long address = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off;
        while (off < upperBound && (JDKUtils.UNSAFE.getLong(buf, address) & 0x8080808080808080L) == 0L) {
            address += 8L;
            off += 8;
        }
        while (off++ < end) {
            if ((JDKUtils.UNSAFE.getByte(buf, address++) & 0x80) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNonSlashASCII(byte[] buf, int off, int len) {
        long x;
        long d;
        int end = off + len;
        int upperBound = off + (len & 0xFFFFFFF8);
        long addr = JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)off;
        while (off < upperBound && (((d = JDKUtils.UNSAFE.getLong(buf, addr)) | (x = d ^ 0x5C5C5C5C5C5C5C5CL) - 0x101010101010101L & (x ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8080808080808080L) == 0L) {
            addr += 8L;
            off += 8;
        }
        while (off++ < end) {
            byte b;
            if (((b = JDKUtils.UNSAFE.getByte(buf, addr++)) & 0x80) == 0 && b != 92) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigitLatin1(int c) {
        return c >= 48 && c <= 57;
    }

    public static int parseInt(byte[] buf, int off, int len) {
        int d;
        byte fc = buf[off];
        int result = IOUtils.isDigitLatin1(fc) ? 48 - fc : (len != 1 && (fc == 45 || fc == 43) ? 0 : 1);
        int end = off + len;
        ++off;
        while (off + 1 < end && (d = IOUtils.digit2(buf, off)) != -1 && -21474836 <= result & result <= 0) {
            result = result * 100 - d;
            off += 2;
        }
        if (off < end && IOUtils.isDigitLatin1(d = buf[off]) && -214748364 <= result & result <= 0) {
            result = result * 10 + 48 - d;
            ++off;
        }
        if (off == end & result <= 0 & (Integer.MIN_VALUE < result || fc == 45)) {
            return fc == 45 ? result : -result;
        }
        throw new NumberFormatException(new String(buf, off, len));
    }

    static {
        POWER_TEN = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        short[] shorts = new short[]{12336, 12592, 12848, 13104, 13360, 13616, 13872, 14128, 14384, 14640, 12337, 12593, 12849, 13105, 13361, 13617, 13873, 14129, 14385, 14641, 12338, 12594, 12850, 13106, 13362, 13618, 13874, 14130, 14386, 14642, 12339, 12595, 12851, 13107, 13363, 13619, 13875, 14131, 14387, 14643, 12340, 12596, 12852, 13108, 13364, 13620, 13876, 14132, 14388, 14644, 12341, 12597, 12853, 13109, 13365, 13621, 13877, 14133, 14389, 14645, 12342, 12598, 12854, 13110, 13366, 13622, 13878, 14134, 14390, 14646, 12343, 12599, 12855, 13111, 13367, 13623, 13879, 14135, 14391, 14647, 12344, 12600, 12856, 13112, 13368, 13624, 13880, 14136, 14392, 14648, 12345, 12601, 12857, 13113, 13369, 13625, 13881, 14137, 14393, 14649, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] digits = new int[]{0x300030, 0x310030, 0x320030, 0x330030, 0x340030, 0x350030, 0x360030, 0x370030, 0x380030, 0x390030, 0x300031, 0x310031, 3276849, 0x330031, 3407921, 3473457, 3538993, 3604529, 3670065, 3735601, 0x300032, 3211314, 0x320032, 0x330032, 3407922, 3473458, 3538994, 3604530, 3670066, 3735602, 0x300033, 0x310033, 0x320033, 0x330033, 0x340033, 0x350033, 0x360033, 0x370033, 0x380033, 0x390033, 0x300034, 3211316, 3276852, 0x330034, 0x340034, 3473460, 3538996, 3604532, 3670068, 3735604, 0x300035, 3211317, 3276853, 0x330035, 3407925, 0x350035, 3538997, 3604533, 3670069, 3735605, 0x300036, 3211318, 3276854, 0x330036, 3407926, 3473462, 0x360036, 3604534, 3670070, 3735606, 0x300037, 3211319, 3276855, 0x330037, 3407927, 3473463, 3538999, 0x370037, 3670071, 3735607, 0x300038, 3211320, 3276856, 0x330038, 3407928, 3473464, 3539000, 3604536, 0x380038, 3735608, 0x300039, 3211321, 3276857, 0x330039, 3407929, 3473465, 3539001, 3604537, 3670073, 0x390039, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        PACKED_DIGITS = shorts;
        PACKED_DIGITS_UTF16 = digits;
        for (int i = 0; i < 1000; ++i) {
            int c0 = i < 10 ? 2 : (i < 100 ? 1 : 0);
            int c1 = i / 100 + 48;
            int c2 = i / 10 % 10 + 48;
            int c3 = i % 10 + 48;
            IOUtils.DIGITS_K_32[i] = c0 + (c1 << 8) + (c2 << 16) + (c3 << 24);
            long v = (long)(c1 << 16) + ((long)c2 << 32) + ((long)c3 << 48);
            IOUtils.DIGITS_K_64[i] = (long)c0 + v;
        }
        ZERO_DOT_LATIN1 = JDKUtils.UNSAFE.getShort(new byte[]{48, 46}, JDKUtils.ARRAY_BYTE_BASE_OFFSET);
    }
}

