/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.NAsyncHttpClient;
import com.alibaba.nacos.common.http.NSyncHttpClient;
import com.alibaba.nacos.common.http.NacosAsyncHttpClient;
import com.alibaba.nacos.common.http.NacosSyncHttpClient;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientManager.class);
    private static final int TIMEOUT = Integer.getInteger("nacos.http.timeout", 5000);
    private static final RequestConfig DEFAULT_CONFIG = RequestConfig.custom().setConnectTimeout(TIMEOUT).setSocketTimeout(TIMEOUT << 1).build();
    private static final NSyncHttpClient SYNC_HTTP_CLIENT = new NacosSyncHttpClient(HttpClients.custom().setDefaultRequestConfig(DEFAULT_CONFIG).build());
    private static final NAsyncHttpClient ASYNC_HTTP_CLIENT = new NacosAsyncHttpClient(HttpAsyncClients.custom().setDefaultRequestConfig(DEFAULT_CONFIG).build());
    private static final AtomicBoolean ALREADY_SHUTDOWN = new AtomicBoolean(false);

    public static NSyncHttpClient getSyncHttpClient() {
        return SYNC_HTTP_CLIENT;
    }

    public static NAsyncHttpClient getAsyncHttpClient() {
        return ASYNC_HTTP_CLIENT;
    }

    public static void shutdown() {
        if (!ALREADY_SHUTDOWN.compareAndSet(false, true)) {
            return;
        }
        LOGGER.warn("[HttpClientManager] Start destroying HttpClient");
        try {
            SYNC_HTTP_CLIENT.close();
            ASYNC_HTTP_CLIENT.close();
        }
        catch (Exception ex) {
            LOGGER.error("An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace(ex));
        }
        LOGGER.warn("[HttpClientManager] Destruction of the end");
    }

    static {
        ThreadUtils.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                HttpClientManager.shutdown();
            }
        });
    }
}

