/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.lang;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedElement<T>
implements Delayed {
    private final long delay;
    private final long expire;
    private final T data;
    private final long now;

    public DelayedElement(long delay, T data) {
        this.delay = delay;
        this.data = data;
        this.expire = System.currentTimeMillis() + delay;
        this.now = System.currentTimeMillis();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelayedElement{");
        sb.append("delay=").append(this.delay);
        sb.append(", expire=").append(this.expire);
        sb.append(", msg='").append(this.data).append('\'');
        sb.append(", now=").append(this.now);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelayedElement that = (DelayedElement)o;
        return this.data != null ? this.data.equals(that.data) : that.data == null;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getExpire() {
        return this.expire;
    }

    public T getData() {
        return this.data;
    }

    public long getNow() {
        return this.now;
    }
}

