/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.ext.file.store.aliyunoss;

import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.ext.file.store.FileStore;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import java.io.InputStream;
import java.util.Map;

public class AliyunOssFileStore
implements FileStore {
    private OSSClient ossClient;
    private String bucketName;

    public AliyunOssFileStore(OSSClient ossClient, String bucketName) {
        this.ossClient = ossClient;
        this.bucketName = bucketName;
    }

    public void save(String path, InputStream inputStream, Map<String, Object> runtimeParams) {
        String bucketName = (String)runtimeParams.get("bucketName");
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            this.ossClient.putObject(this.bucketName, path, inputStream);
        } else {
            this.ossClient.putObject(bucketName, path, inputStream);
        }
    }

    public InputStream get(String path, Map<String, Object> runtimeParams) {
        String bucketName = (String)runtimeParams.get("bucketName");
        OSSObject object = StringUtils.isBlank((CharSequence)bucketName) ? this.ossClient.getObject(this.bucketName, path) : this.ossClient.getObject(bucketName, path);
        if (object == null) {
            return null;
        }
        return object.getObjectContent();
    }

    public void remove(String path, Map<String, Object> runtimeParams) {
        String bucketName = (String)runtimeParams.get("bucketName");
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            this.ossClient.deleteObject(this.bucketName, path);
        } else {
            this.ossClient.deleteObject(bucketName, path);
        }
    }

    public boolean exists(String path, Map<String, Object> runtimeParams) {
        String bucketName = (String)runtimeParams.get("bucketName");
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            return this.ossClient.doesObjectExist(this.bucketName, path);
        }
        return this.ossClient.doesObjectExist(bucketName, path);
    }
}

