/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core;

import com.alibaba.ageiport.common.function.Builder;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.ext.file.store.FileStore;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.executor.DataMergeExecutor;
import com.alibaba.ageiport.processor.core.executor.MainWorkerExecutor;
import com.alibaba.ageiport.processor.core.executor.SubWorkerExecutor;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.spi.AgeiPortFactory;
import com.alibaba.ageiport.processor.core.spi.cache.BigDataCacheManager;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.processor.core.spi.cluster.ClusterManager;
import com.alibaba.ageiport.processor.core.spi.dispatcher.DispatcherManager;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBus;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBusManager;
import com.alibaba.ageiport.processor.core.spi.listener.ListenerManager;
import com.alibaba.ageiport.processor.core.spi.publisher.PublisherManager;
import com.alibaba.ageiport.processor.core.spi.service.TaskService;
import com.alibaba.ageiport.processor.core.spi.task.acceptor.TaskAcceptor;
import com.alibaba.ageiport.processor.core.spi.task.callback.MainTaskCallback;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressMonitor;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressService;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskStageEvent;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationRegistry;
import com.alibaba.ageiport.processor.core.spi.task.stage.CommonStage;
import com.alibaba.ageiport.security.Security;
import java.util.Date;

public interface AgeiPort {
    public static final Logger LOGGER = LoggerFactory.getLogger(AgeiPort.class);

    public static AgeiPort ageiPort() {
        AgeiPortOptions options = new AgeiPortOptions();
        AgeiPortFactory factory = (AgeiPortFactory)ExtensionLoader.getExtensionLoader(AgeiPortFactory.class).getOrDefaultExtension(options.getFactory());
        return factory.ageiPort(options);
    }

    public static AgeiPort ageiPort(AgeiPortOptions options) {
        AgeiPortFactory factory = (AgeiPortFactory)ExtensionLoader.getExtensionLoader(AgeiPortFactory.class).getOrDefaultExtension(options.getFactory());
        return factory.ageiPort(options);
    }

    public AgeiPortOptions getOptions();

    public Security getSecurity();

    public FileStore getFileStore();

    public TaskService getTaskService();

    public TaskServerClient getTaskServerClient();

    public MainWorkerExecutor getMainWorkerExecutor();

    public SubWorkerExecutor getSubWorkerExecutor();

    public DataMergeExecutor getDataMergeExecutor();

    public TaskSpiSelector getTaskSpiSelector();

    public TaskSpecificationRegistry getSpecificationRegistry();

    public EventBusManager getEventBusManager();

    public PublisherManager getPublisherManager();

    public ListenerManager getListenerManager();

    public BigDataCacheManager getBigDataCacheManager();

    public TaskProgressMonitor getTaskProgressMonitor();

    public TaskProgressService getTaskProgressService();

    public EventBus getLocalEventBus();

    public EventBus getClusterEventBus();

    public DispatcherManager getDispatcherManager();

    public TaskAcceptor getTaskAcceptor();

    public ClusterManager getClusterManager();

    public MainTaskCallback getMainTaskCallback();

    public <T, P> T getBean(Class<T> var1, Builder<T, P> var2, P var3);

    public <T> T setBean(T var1);

    default public void onMainError(String mainTaskId, Throwable throwable) {
        MainTask mainTask = this.getTaskServerClient().getMainTask(mainTaskId);
        this.onMainError(mainTask, throwable);
    }

    default public void onSubError(String subTaskId, Throwable throwable) {
        SubTask subTask = this.getTaskServerClient().getSubTask(subTaskId);
        this.onSubError(subTask, throwable);
    }

    default public void onMainError(MainTask mainTask, Throwable throwable) {
        try {
            LOGGER.error("onError MainTask, main:{}", new Object[]{mainTask.getMainTaskId(), throwable});
            AgeiPort ageiPort = this;
            ageiPort.getMainTaskCallback().beforeError(mainTask);
            mainTask.setGmtFinished(new Date());
            mainTask.setStatus("ERROR");
            if (mainTask.getResultMessage() == null && throwable != null) {
                mainTask.setResultMessage(throwable.getMessage());
                if (throwable instanceof BizException) {
                    BizException bizException = (BizException)throwable;
                    mainTask.setResultCode(bizException.getErrorCode());
                }
            }
            ageiPort.getTaskServerClient().updateMainTask(mainTask);
            if ("STANDALONE".equals(mainTask.getExecuteType())) {
                ageiPort.getLocalEventBus().post(TaskStageEvent.mainTaskEvent(mainTask.getMainTaskId(), CommonStage.ERROR));
            } else {
                ageiPort.getClusterEventBus().post(TaskStageEvent.mainTaskEvent(mainTask.getMainTaskId(), CommonStage.ERROR));
            }
            ageiPort.getMainTaskCallback().afterError(mainTask);
        }
        catch (Throwable e) {
            LOGGER.error("onError MainTask failed, ", e);
        }
    }

    default public void onSubError(SubTask subTask, Throwable throwable) {
        try {
            LOGGER.error("onError SubTask, main:{}, sub:{}", new Object[]{subTask.getMainTaskId(), subTask.getSubTaskNo(), throwable});
            AgeiPort ageiPort = this;
            subTask.setGmtFinished(new Date());
            subTask.setStatus("ERROR");
            if (subTask.getResultMessage() == null) {
                subTask.setResultMessage(throwable.getMessage());
                if (throwable instanceof BizException) {
                    BizException bizException = (BizException)throwable;
                    subTask.setResultCode(bizException.getErrorCode());
                }
            }
            ageiPort.getTaskServerClient().updateSubTask(subTask);
            if ("STANDALONE".equals(subTask.getExecuteType())) {
                ageiPort.getLocalEventBus().post(TaskStageEvent.subTaskEvent(subTask.getSubTaskId(), CommonStage.ERROR));
            } else {
                ageiPort.getClusterEventBus().post(TaskStageEvent.subTaskEvent(subTask.getSubTaskId(), CommonStage.ERROR));
            }
        }
        catch (Throwable e) {
            LOGGER.error("onError SubTask failed, ", e);
        }
    }
}

