/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core;

import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.NetUtils;
import com.alibaba.ageiport.ext.file.store.FileStoreOptions;
import com.alibaba.ageiport.processor.core.api.http.HttpApiServerOptions;
import com.alibaba.ageiport.processor.core.client.http.HttpTaskServerClientOptions;
import com.alibaba.ageiport.processor.core.client.memory.MemoryTaskServerClientOptions;
import com.alibaba.ageiport.processor.core.cluster.DefaultClusterOptions;
import com.alibaba.ageiport.processor.core.constants.ConstValues;
import com.alibaba.ageiport.processor.core.dispatcher.http.HttpDispatcherOptions;
import com.alibaba.ageiport.processor.core.dispatcher.local.LocalDispatcherOptions;
import com.alibaba.ageiport.processor.core.eventbus.http.HttpEventBusOptions;
import com.alibaba.ageiport.processor.core.eventbus.local.LocalEventBusOptions;
import com.alibaba.ageiport.processor.core.file.excel.ExcelWriteHandlerProviderSpiConfig;
import com.alibaba.ageiport.processor.core.file.store.LocalFileStoreOptions;
import com.alibaba.ageiport.processor.core.spi.api.ApiServerOptions;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClientOptions;
import com.alibaba.ageiport.processor.core.spi.cluster.ClusterOptions;
import com.alibaba.ageiport.processor.core.spi.dispatcher.DispatcherOptions;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBusOptions;
import java.util.HashMap;
import java.util.Map;

public class AgeiPortOptions {
    private String factory = "AgeiPortFactoryImpl";
    private String namespace;
    private String app;
    private String accessKeyId;
    private String accessKeySecret;
    private ClusterOptions clusterOptions = new DefaultClusterOptions();
    private FileStoreOptions fileStoreOptions = new LocalFileStoreOptions();
    private TaskServerClientOptions taskServerClientOptions = new HttpTaskServerClientOptions();
    private ApiServerOptions apiServerOptions = new HttpApiServerOptions();
    private SubWorkerExecutor subWorkerExecutor = new SubWorkerExecutor();
    private MainWorkerExecutor mainWorkerExecutor = new MainWorkerExecutor();
    private DataMergeExecutor dataMergeExecutor = new DataMergeExecutor();
    private Security security = new Security();
    private Local local = new Local();
    private Cluster cluster = new Cluster();
    private String localBigDataCache = "LocalMemoryBigDataCache";
    private String clusterBigDataCache = "FileStoreBigDataCache";
    private Integer bigDataCacheExpireMs = ConstValues.DEFAULT_MAX_TASK_TIMEOUT;
    private String taskAcceptor = "DefaultTaskAcceptorFactory";
    private String mainTaskCallback = "DefaultMainTaskCallback";
    private Map<String, String> spiSelectMappings = new HashMap<String, String>();
    private Map<String, Map<String, String>> spiConfigs = new HashMap<String, Map<String, String>>();
    private Map<String, String> fileTypeWriterSpiMappings = new HashMap<String, String>();
    private Map<String, String> fileTypeReaderSpiMappings = new HashMap<String, String>();

    public AgeiPortOptions() {
        this.fileTypeWriterSpiMappings.put("xlsx", "ExcelFileWriterFactory");
        this.fileTypeReaderSpiMappings.put("xlsx", "ExcelFileReaderFactory");
        this.fileTypeWriterSpiMappings.put("xls", "ExcelFileWriterFactory");
        this.fileTypeReaderSpiMappings.put("xls", "ExcelFileReaderFactory");
        this.fileTypeWriterSpiMappings.put("xlsm", "ExcelFileWriterFactory");
        this.fileTypeReaderSpiMappings.put("xlsm", "ExcelFileReaderFactory");
        this.fileTypeWriterSpiMappings.put("csv", "ExcelFileWriterFactory");
        this.fileTypeReaderSpiMappings.put("csv", "ExcelFileReaderFactory");
        ExcelWriteHandlerProviderSpiConfig excelWriteHandlerProviderSpiConfig = new ExcelWriteHandlerProviderSpiConfig();
        this.spiConfigs.put("ExcelWriteHandlerProvider", JsonUtil.toMap((Object)excelWriteHandlerProviderSpiConfig));
    }

    public static AgeiPortOptions debug() {
        AgeiPortOptions options = new AgeiPortOptions();
        Debug debug = new Debug();
        if (debug.getNamespace() != null) {
            options.setNamespace(debug.getNamespace());
        }
        if (debug.getApp() != null) {
            options.setApp(debug.getApp());
        }
        if (debug.getAccessKeyId() != null) {
            options.setAccessKeyId(debug.getAccessKeyId());
        }
        if (debug.getAccessKeySecret() != null) {
            options.setAccessKeySecret(debug.getAccessKeySecret());
        }
        if (debug.getFileStoreOptions() != null) {
            options.setFileStoreOptions(debug.getFileStoreOptions());
        }
        if (debug.getTaskServerClientOptions() != null) {
            HttpTaskServerClientOptions clientOptions = new HttpTaskServerClientOptions();
            boolean portAvailable = NetUtils.isPortAvailable((int)clientOptions.getPort());
            if (portAvailable) {
                clientOptions.setEndpoint("localhost");
                options.setTaskServerClientOptions(clientOptions);
            } else {
                options.setTaskServerClientOptions(debug.getTaskServerClientOptions());
            }
        }
        return options;
    }

    public String toString() {
        return "AgeiPortOptions(factory=" + this.getFactory() + ", namespace=" + this.getNamespace() + ", app=" + this.getApp() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", clusterOptions=" + this.getClusterOptions() + ", fileStoreOptions=" + this.getFileStoreOptions() + ", taskServerClientOptions=" + this.getTaskServerClientOptions() + ", apiServerOptions=" + this.getApiServerOptions() + ", subWorkerExecutor=" + this.getSubWorkerExecutor() + ", mainWorkerExecutor=" + this.getMainWorkerExecutor() + ", dataMergeExecutor=" + this.getDataMergeExecutor() + ", security=" + this.getSecurity() + ", local=" + this.getLocal() + ", cluster=" + this.getCluster() + ", localBigDataCache=" + this.getLocalBigDataCache() + ", clusterBigDataCache=" + this.getClusterBigDataCache() + ", bigDataCacheExpireMs=" + this.getBigDataCacheExpireMs() + ", taskAcceptor=" + this.getTaskAcceptor() + ", mainTaskCallback=" + this.getMainTaskCallback() + ", spiSelectMappings=" + this.getSpiSelectMappings() + ", spiConfigs=" + this.getSpiConfigs() + ", fileTypeWriterSpiMappings=" + this.getFileTypeWriterSpiMappings() + ", fileTypeReaderSpiMappings=" + this.getFileTypeReaderSpiMappings() + ")";
    }

    public String getFactory() {
        return this.factory;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getApp() {
        return this.app;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public ClusterOptions getClusterOptions() {
        return this.clusterOptions;
    }

    public FileStoreOptions getFileStoreOptions() {
        return this.fileStoreOptions;
    }

    public TaskServerClientOptions getTaskServerClientOptions() {
        return this.taskServerClientOptions;
    }

    public ApiServerOptions getApiServerOptions() {
        return this.apiServerOptions;
    }

    public SubWorkerExecutor getSubWorkerExecutor() {
        return this.subWorkerExecutor;
    }

    public MainWorkerExecutor getMainWorkerExecutor() {
        return this.mainWorkerExecutor;
    }

    public DataMergeExecutor getDataMergeExecutor() {
        return this.dataMergeExecutor;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Local getLocal() {
        return this.local;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public String getLocalBigDataCache() {
        return this.localBigDataCache;
    }

    public String getClusterBigDataCache() {
        return this.clusterBigDataCache;
    }

    public Integer getBigDataCacheExpireMs() {
        return this.bigDataCacheExpireMs;
    }

    public String getTaskAcceptor() {
        return this.taskAcceptor;
    }

    public String getMainTaskCallback() {
        return this.mainTaskCallback;
    }

    public Map<String, String> getSpiSelectMappings() {
        return this.spiSelectMappings;
    }

    public Map<String, Map<String, String>> getSpiConfigs() {
        return this.spiConfigs;
    }

    public Map<String, String> getFileTypeWriterSpiMappings() {
        return this.fileTypeWriterSpiMappings;
    }

    public Map<String, String> getFileTypeReaderSpiMappings() {
        return this.fileTypeReaderSpiMappings;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public void setClusterOptions(ClusterOptions clusterOptions) {
        this.clusterOptions = clusterOptions;
    }

    public void setFileStoreOptions(FileStoreOptions fileStoreOptions) {
        this.fileStoreOptions = fileStoreOptions;
    }

    public void setTaskServerClientOptions(TaskServerClientOptions taskServerClientOptions) {
        this.taskServerClientOptions = taskServerClientOptions;
    }

    public void setApiServerOptions(ApiServerOptions apiServerOptions) {
        this.apiServerOptions = apiServerOptions;
    }

    public void setSubWorkerExecutor(SubWorkerExecutor subWorkerExecutor) {
        this.subWorkerExecutor = subWorkerExecutor;
    }

    public void setMainWorkerExecutor(MainWorkerExecutor mainWorkerExecutor) {
        this.mainWorkerExecutor = mainWorkerExecutor;
    }

    public void setDataMergeExecutor(DataMergeExecutor dataMergeExecutor) {
        this.dataMergeExecutor = dataMergeExecutor;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public void setLocalBigDataCache(String localBigDataCache) {
        this.localBigDataCache = localBigDataCache;
    }

    public void setClusterBigDataCache(String clusterBigDataCache) {
        this.clusterBigDataCache = clusterBigDataCache;
    }

    public void setBigDataCacheExpireMs(Integer bigDataCacheExpireMs) {
        this.bigDataCacheExpireMs = bigDataCacheExpireMs;
    }

    public void setTaskAcceptor(String taskAcceptor) {
        this.taskAcceptor = taskAcceptor;
    }

    public void setMainTaskCallback(String mainTaskCallback) {
        this.mainTaskCallback = mainTaskCallback;
    }

    public void setSpiSelectMappings(Map<String, String> spiSelectMappings) {
        this.spiSelectMappings = spiSelectMappings;
    }

    public void setSpiConfigs(Map<String, Map<String, String>> spiConfigs) {
        this.spiConfigs = spiConfigs;
    }

    public void setFileTypeWriterSpiMappings(Map<String, String> fileTypeWriterSpiMappings) {
        this.fileTypeWriterSpiMappings = fileTypeWriterSpiMappings;
    }

    public void setFileTypeReaderSpiMappings(Map<String, String> fileTypeReaderSpiMappings) {
        this.fileTypeReaderSpiMappings = fileTypeReaderSpiMappings;
    }

    public static class SubWorkerExecutor {
        private String name = "SubWorker";
        private int corePoolSize = 4;
        private int maxPoolSize = 8;
        private int queueSize = 128;
        private int timeoutMs = 1800000;

        public String getName() {
            return this.name;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getTimeoutMs() {
            return this.timeoutMs;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public void setTimeoutMs(int timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public String toString() {
            return "AgeiPortOptions.SubWorkerExecutor(name=" + this.getName() + ", corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", queueSize=" + this.getQueueSize() + ", timeoutMs=" + this.getTimeoutMs() + ")";
        }
    }

    public static class MainWorkerExecutor {
        private String name = "MainWorker";
        private int corePoolSize = 4;
        private int maxPoolSize = 8;
        private int queueSize = 128;
        private int timeoutMs = 1800000;

        public String getName() {
            return this.name;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getTimeoutMs() {
            return this.timeoutMs;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public void setTimeoutMs(int timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public String toString() {
            return "AgeiPortOptions.MainWorkerExecutor(name=" + this.getName() + ", corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", queueSize=" + this.getQueueSize() + ", timeoutMs=" + this.getTimeoutMs() + ")";
        }
    }

    public static class DataMergeExecutor {
        private String name = "MergeWorker";
        private int corePoolSize = 4;
        private int maxPoolSize = 8;
        private int queueSize = 16;
        private int timeoutMs = 1800000;

        public String getName() {
            return this.name;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getTimeoutMs() {
            return this.timeoutMs;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public void setTimeoutMs(int timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public String toString() {
            return "AgeiPortOptions.DataMergeExecutor(name=" + this.getName() + ", corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaxPoolSize() + ", queueSize=" + this.getQueueSize() + ", timeoutMs=" + this.getTimeoutMs() + ")";
        }
    }

    public static class Security {
        private String signerName = "HmacSHA256";
        private String signerComposerName = "DefaultSignerComposer";

        public String getSignerName() {
            return this.signerName;
        }

        public String getSignerComposerName() {
            return this.signerComposerName;
        }

        public void setSignerName(String signerName) {
            this.signerName = signerName;
        }

        public void setSignerComposerName(String signerComposerName) {
            this.signerComposerName = signerComposerName;
        }

        public String toString() {
            return "AgeiPortOptions.Security(signerName=" + this.getSignerName() + ", signerComposerName=" + this.getSignerComposerName() + ")";
        }
    }

    public static class Local {
        private EventBusOptions eventBusOptions = new LocalEventBusOptions();
        private DispatcherOptions dispatcherOptions = new LocalDispatcherOptions();

        public EventBusOptions getEventBusOptions() {
            return this.eventBusOptions;
        }

        public DispatcherOptions getDispatcherOptions() {
            return this.dispatcherOptions;
        }

        public void setEventBusOptions(EventBusOptions eventBusOptions) {
            this.eventBusOptions = eventBusOptions;
        }

        public void setDispatcherOptions(DispatcherOptions dispatcherOptions) {
            this.dispatcherOptions = dispatcherOptions;
        }

        public String toString() {
            return "AgeiPortOptions.Local(eventBusOptions=" + this.getEventBusOptions() + ", dispatcherOptions=" + this.getDispatcherOptions() + ")";
        }
    }

    public static class Cluster {
        private EventBusOptions eventBusOptions = new HttpEventBusOptions();
        private DispatcherOptions dispatcherOptions = new HttpDispatcherOptions();

        public EventBusOptions getEventBusOptions() {
            return this.eventBusOptions;
        }

        public DispatcherOptions getDispatcherOptions() {
            return this.dispatcherOptions;
        }

        public void setEventBusOptions(EventBusOptions eventBusOptions) {
            this.eventBusOptions = eventBusOptions;
        }

        public void setDispatcherOptions(DispatcherOptions dispatcherOptions) {
            this.dispatcherOptions = dispatcherOptions;
        }

        public String toString() {
            return "AgeiPortOptions.Cluster(eventBusOptions=" + this.getEventBusOptions() + ", dispatcherOptions=" + this.getDispatcherOptions() + ")";
        }
    }

    private static class Debug {
        private String namespace = "namespace";
        private String app = "app";
        private String accessKeyId = "accessKeyId";
        private String accessKeySecret = "accessKeySecret";
        private FileStoreOptions fileStoreOptions = new LocalFileStoreOptions();
        private TaskServerClientOptions taskServerClientOptions = new MemoryTaskServerClientOptions();

        private Debug() {
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getApp() {
            return this.app;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public FileStoreOptions getFileStoreOptions() {
            return this.fileStoreOptions;
        }

        public TaskServerClientOptions getTaskServerClientOptions() {
            return this.taskServerClientOptions;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public void setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
        }

        public void setFileStoreOptions(FileStoreOptions fileStoreOptions) {
            this.fileStoreOptions = fileStoreOptions;
        }

        public void setTaskServerClientOptions(TaskServerClientOptions taskServerClientOptions) {
            this.taskServerClientOptions = taskServerClientOptions;
        }

        public String toString() {
            return "AgeiPortOptions.Debug(namespace=" + this.getNamespace() + ", app=" + this.getApp() + ", accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", fileStoreOptions=" + this.getFileStoreOptions() + ", taskServerClientOptions=" + this.getTaskServerClientOptions() + ")";
        }
    }

    public static class EventBus {
        private String clusterEventBus = "HttpEventBus";
        private String localEventBus = "LocalAsyncEventBus";

        public String getClusterEventBus() {
            return this.clusterEventBus;
        }

        public String getLocalEventBus() {
            return this.localEventBus;
        }

        public void setClusterEventBus(String clusterEventBus) {
            this.clusterEventBus = clusterEventBus;
        }

        public void setLocalEventBus(String localEventBus) {
            this.localEventBus = localEventBus;
        }

        public String toString() {
            return "AgeiPortOptions.EventBus(clusterEventBus=" + this.getClusterEventBus() + ", localEventBus=" + this.getLocalEventBus() + ")";
        }
    }
}

