/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.api.http;

import com.alibaba.ageiport.common.function.Handler;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.api.http.HttpApiServerOptions;
import com.alibaba.ageiport.processor.core.api.http.HttpApiVerticle;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.spi.api.ApiServer;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.SyncExtensionApiRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.SyncExtensionApiResponse;
import com.alibaba.ageiport.processor.core.spi.service.SyncExtensionApiParam;
import com.alibaba.ageiport.processor.core.spi.service.SyncExtensionApiResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskService;
import com.alibaba.ageiport.processor.core.spi.task.stage.CommonStage;
import com.alibaba.ageiport.processor.core.spi.task.stage.Stage;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;

public class HttpApiServer
implements ApiServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiServer.class);
    public static final String TASK_PROGRESS_URL = "/TaskProgress";
    public static final String TASK_EXECUTE_URL = "/TaskExecute";
    public static final String SYNC_EXTENSION_API_URL = "/SyncExecute";
    public static final String TASK_HEALTH = "/ping";
    private AgeiPort ageiPort;
    private HttpClient httpClient;
    private HttpApiServerOptions options;

    public HttpApiServer(AgeiPort ageiPort, HttpApiServerOptions options) {
        this.ageiPort = ageiPort;
        this.options = options;
        Vertx vertx = ageiPort.getBean(Vertx.class, s -> Vertx.vertx(), ageiPort);
        this.httpClient = vertx.createHttpClient();
        HttpApiVerticle verticle = new HttpApiVerticle(ageiPort, options, this);
        vertx.deployVerticle((Verticle)verticle);
    }

    @Override
    public void executeTask(ExecuteMainTaskRequest request, Handler<ExecuteMainTaskResponse> handler) {
        TaskExecuteParam taskExecuteParam = (TaskExecuteParam)BeanUtils.cloneProp((Object)((Object)request), TaskExecuteParam.class);
        TaskExecuteResult executeResult = this.ageiPort.getTaskService().executeTask(taskExecuteParam);
        ExecuteMainTaskResponse response = new ExecuteMainTaskResponse();
        response.setSuccess(executeResult.getSuccess());
        response.setMessage(executeResult.getErrorMessage());
        response.setMainTaskId(executeResult.getMainTaskId());
        handler.handle((Object)response);
    }

    @Override
    public void getTaskProgress(GetMainTaskProgressRequest request, Handler<GetMainTaskProgressResponse> handler) {
        String mainTaskId = request.getMainTaskId();
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(mainTaskId);
        if (this.isTaskInFinal(mainTask)) {
            GetMainTaskProgressResponse response = new GetMainTaskProgressResponse();
            response.setSuccess(true);
            response.setMainTaskId(mainTask.getMainTaskId());
            response.setStatus(mainTask.getStatus());
            Stage stage = CommonStage.of(mainTask.getStatus());
            response.setStageCode(stage.getCode());
            response.setStageName(stage.getName());
            response.setErrorSubTaskCount(mainTask.getSubFailedCount());
            response.setTotalSubTaskCount(mainTask.getSubTotalCount());
            response.setFinishedSubTaskCount(mainTask.getSubFinishedCount());
            response.setPercent(1.0);
            response.setIsFinished(stage == CommonStage.FINISHED);
            response.setIsError(stage == CommonStage.ERROR);
            handler.handle((Object)response);
            return;
        }
        if (this.canUserCurrentNode(mainTask)) {
            TaskProgressParam taskProgressRequest = new TaskProgressParam(mainTaskId);
            TaskService taskService = this.ageiPort.getTaskService();
            TaskProgressResult taskProgressResult = taskService.getTaskProgress(taskProgressRequest);
            GetMainTaskProgressResponse response = (GetMainTaskProgressResponse)((Object)BeanUtils.cloneProp((Object)taskProgressResult, GetMainTaskProgressResponse.class));
            response.setSuccess(true);
            handler.handle((Object)response);
            return;
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(mainTask.getHost()).setPort(this.options.getPort()).setMethod(HttpMethod.POST).setURI(TASK_PROGRESS_URL).setTimeout(1000L);
        this.httpClient.request(requestOptions, e -> {
            String message = StringUtils.format((String)"getTaskProgress response failed main:{}, host{}", (Object[])new Object[]{mainTaskId, mainTask.getHost()});
            if (e.succeeded()) {
                HttpClientRequest httpClientRequest = (HttpClientRequest)e.result();
                String requestJson = JsonUtil.toJsonString((Object)((Object)request));
                httpClientRequest.send(requestJson, asyncResult -> {
                    if (asyncResult.succeeded()) {
                        String jsonString = ((HttpClientResponse)asyncResult.result()).body().toString();
                        GetMainTaskProgressResponse response = (GetMainTaskProgressResponse)((Object)((Object)((Object)JsonUtil.toObject((String)jsonString, GetMainTaskProgressResponse.class))));
                        handler.handle((Object)response);
                    } else {
                        logger.error(message, asyncResult.cause());
                        GetMainTaskProgressResponse response = new GetMainTaskProgressResponse();
                        response.setSuccess(false);
                        response.setMessage(message);
                        handler.handle((Object)response);
                    }
                });
            } else {
                logger.error(message, e.cause());
                GetMainTaskProgressResponse response = new GetMainTaskProgressResponse();
                response.setSuccess(false);
                response.setMessage(message);
                handler.handle((Object)response);
            }
        });
    }

    @Override
    public void executeSyncExtension(SyncExtensionApiRequest request, Handler<SyncExtensionApiResponse> handler) {
        SyncExtensionApiParam syncExtensionApiParam = (SyncExtensionApiParam)BeanUtils.cloneProp((Object)((Object)request), SyncExtensionApiParam.class);
        SyncExtensionApiResult executeResult = this.ageiPort.getTaskService().executeSyncExtension(syncExtensionApiParam);
        SyncExtensionApiResponse response = new SyncExtensionApiResponse();
        response.setSuccess(executeResult.getSuccess());
        response.setMessage(executeResult.getErrorMessage());
        handler.handle((Object)response);
    }

    private boolean canUserCurrentNode(MainTask mainTask) {
        return this.ageiPort.getClusterManager().getLocalNode().getHost().equals(mainTask.getHost());
    }

    private boolean isTaskInFinal(MainTask mainTask) {
        return mainTask.getStatus().equals(CommonStage.ERROR.getCode()) || mainTask.getStatus().equals(CommonStage.FINISHED.getCode());
    }
}

