/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.api.http;

import com.alibaba.ageiport.common.function.Handler;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.api.http.HttpApiServerOptions;
import com.alibaba.ageiport.processor.core.spi.api.ApiServer;
import com.alibaba.ageiport.processor.core.spi.api.model.ApiResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.SyncExtensionApiRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.SyncExtensionApiResponse;
import com.alibaba.fastjson.JSON;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import java.util.HashMap;

public class HttpApiVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiVerticle.class);
    private AgeiPort ageiPort;
    private HttpApiServerOptions options;
    HttpClient httpClient;
    private ApiServer apiServer;

    public HttpApiVerticle(AgeiPort ageiPort, HttpApiServerOptions options, ApiServer apiServer) {
        this.ageiPort = ageiPort;
        this.options = options;
        this.apiServer = apiServer;
    }

    public void start() {
        this.httpClient = this.vertx.createHttpClient();
        this.vertx.createHttpServer().requestHandler(request -> request.body(event -> {
            if (event.succeeded()) {
                String requestJson = ((Buffer)event.result()).toString();
                switch (request.uri()) {
                    case "/TaskProgress": {
                        GetMainTaskProgressRequest req = (GetMainTaskProgressRequest)((Object)((Object)((Object)JsonUtil.toObject((String)requestJson, GetMainTaskProgressRequest.class))));
                        this.apiServer.getTaskProgress(req, (Handler<GetMainTaskProgressResponse>)((Handler)response -> {
                            String jsonResult = JsonUtil.toJsonString((Object)response);
                            request.response().end(jsonResult);
                        }));
                        break;
                    }
                    case "/TaskExecute": {
                        ExecuteMainTaskRequest req = (ExecuteMainTaskRequest)((Object)((Object)((Object)JsonUtil.toObject((String)requestJson, ExecuteMainTaskRequest.class))));
                        this.apiServer.executeTask(req, (Handler<ExecuteMainTaskResponse>)((Handler)response -> {
                            String jsonResult = JsonUtil.toJsonString((Object)response);
                            request.response().end(jsonResult);
                        }));
                        break;
                    }
                    case "/SyncExecute": {
                        SyncExtensionApiRequest req = (SyncExtensionApiRequest)((Object)((Object)((Object)JsonUtil.toObject((String)requestJson, SyncExtensionApiRequest.class))));
                        this.apiServer.executeSyncExtension(req, (Handler<SyncExtensionApiResponse>)((Handler)response -> {
                            String jsonResult = JsonUtil.toJsonString((Object)response);
                            request.response().end(jsonResult);
                        }));
                        break;
                    }
                    case "/ping": {
                        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
                        result.put("success", Boolean.valueOf(true));
                        result.put("timestamp", Long.valueOf(System.currentTimeMillis()));
                        String jsonResult = JSON.toJSONString(result);
                        request.response().end(jsonResult);
                        break;
                    }
                    default: {
                        ApiResponse apiResponse = new ApiResponse();
                        apiResponse.setSuccess(false);
                        apiResponse.setMessage("not found:" + request.uri());
                        request.response().setStatusCode(404).end();
                        break;
                    }
                }
            } else {
                logger.error("request failed, uri:{}", new Object[]{request.uri(), event.cause()});
                ApiResponse apiResponse = new ApiResponse();
                apiResponse.setSuccess(false);
                apiResponse.setMessage(event.cause().getMessage());
                String responseJson = JsonUtil.toJsonString((Object)((Object)apiResponse));
                request.response().end(responseJson);
            }
        })).listen(this.options.getPort().intValue());
    }
}

