/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.cache;

import com.alibaba.ageiport.common.utils.IOUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.ext.file.store.FileStore;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.spi.cache.BigDataCache;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class FileStoreBigDataCache
implements BigDataCache {
    private AgeiPort ageiPort;
    private FileStore fileStore;

    @Override
    public void init(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        this.fileStore = ageiPort.getFileStore();
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        InputStream inputStream = this.fileStore.get(key, new HashMap());
        try {
            Object t;
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String s = new String(bytes);
            Object object = t = JsonUtil.toObject((String)s, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    public void put(String key, Object value) {
        String s = JsonUtil.toJsonString((Object)value);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
        try {
            this.fileStore.save(key, (InputStream)inputStream, new HashMap());
        }
        catch (Throwable e) {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public <T> T remove(String key, Class<T> clazz) {
        T t = this.get(key, clazz);
        this.fileStore.remove(key, new HashMap());
        return t;
    }

    @Override
    public boolean exist(String key) {
        return this.fileStore.exists(key, new HashMap());
    }
}

