/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.cache;

import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.spi.cache.BigDataCache;
import com.alibaba.ageiport.processor.core.task.monitor.ClearTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalMemoryBigDataCache
implements BigDataCache {
    private AgeiPort ageiPort;
    private Integer timeoutMs;
    private ClearTask clearTask;
    private Map<String, Object> cache;

    @Override
    public void init(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        this.cache = new ConcurrentHashMap<String, Object>();
        this.timeoutMs = ageiPort.getOptions().getBigDataCacheExpireMs();
        this.clearTask = new ClearTask("LocalBigDataCache Cache Task");
    }

    @Override
    public <T> T get(String key, Class<T> clazz) {
        return (T)this.cache.get(key);
    }

    @Override
    public <T> T remove(String key, Class<T> clazz) {
        return (T)this.cache.remove(key);
    }

    @Override
    public boolean exist(String key) {
        return this.cache.containsKey(key);
    }

    public void put(String key, Object value) {
        this.cache.put(key, value);
        this.clearTask.addClearTask(key, this.timeoutMs.intValue(), () -> this.cache.remove(key));
    }
}

