/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.client.memory;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.TaskIdUtil;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.model.core.impl.TaskSpecification;
import com.alibaba.ageiport.processor.core.spi.client.CreateMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.client.CreateSpecificationRequest;
import com.alibaba.ageiport.processor.core.spi.client.CreateSubTasksRequest;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemoryTaskServerClient
implements TaskServerClient {
    public static Logger LOGGER = LoggerFactory.getLogger(MemoryTaskServerClient.class);
    private Map<String, MainTask> mainTaskMap = new HashMap<String, MainTask>();
    private Map<String, SubTask> subTaskMap = new HashMap<String, SubTask>();
    private Map<String, TaskSpecification> taskSpecificationMap = new HashMap<String, TaskSpecification>();

    @Override
    public String createMainTask(CreateMainTaskRequest createMainTaskRequest) {
        MainTask mainTask = (MainTask)BeanUtils.cloneProp((Object)createMainTaskRequest, MainTask.class);
        mainTask.setMainTaskId(TaskIdUtil.genMainTaskId());
        mainTask.setStatus("NEW");
        this.mainTaskMap.put(mainTask.getMainTaskId(), mainTask);
        return mainTask.getMainTaskId();
    }

    @Override
    public void updateMainTask(MainTask mainTask) {
        String mainTaskId = mainTask.getMainTaskId();
        MainTask exist = this.mainTaskMap.get(mainTaskId);
        String mergeFeature = JsonUtil.merge((String)exist.getFeature(), (String)mainTask.getFeature());
        String mergeRuntime = JsonUtil.merge((String)exist.getRuntimeParam(), (String)mainTask.getRuntimeParam());
        String merge = JsonUtil.merge((String)JsonUtil.toJsonString((Object)exist), (String)JsonUtil.toJsonString((Object)mainTask));
        MainTask newTask = (MainTask)JsonUtil.toObject((String)merge, MainTask.class);
        newTask.setFeature(mergeFeature);
        newTask.setRuntimeParam(mergeRuntime);
        this.mainTaskMap.put(mainTaskId, newTask);
    }

    @Override
    public MainTask getMainTask(String mainTaskId) {
        return this.mainTaskMap.get(mainTaskId);
    }

    @Override
    public List<String> createSubTask(CreateSubTasksRequest createSubTasksRequest) {
        ArrayList<String> subTaskIds = new ArrayList<String>();
        String mainTaskId = createSubTasksRequest.getMainTaskId();
        List<CreateSubTasksRequest.SubTaskInstance> subTaskInstances = createSubTasksRequest.getSubTaskInstances();
        for (CreateSubTasksRequest.SubTaskInstance subTaskInstance : subTaskInstances) {
            MainTask mainTask = this.mainTaskMap.get(mainTaskId);
            SubTask subTask = (SubTask)BeanUtils.cloneProp((Object)mainTask, SubTask.class);
            subTask.setSubTaskId(TaskIdUtil.genSubTaskId((String)mainTaskId, (Integer)subTaskInstance.getSubTaskNo()));
            subTask.setMainTaskId(mainTaskId);
            subTask.setRuntimeParam(subTaskInstance.getRuntimeParam());
            subTask.setBizQuery(subTaskInstance.getBizQuery());
            this.subTaskMap.put(subTask.getSubTaskId(), subTask);
            subTaskIds.add(subTask.getSubTaskId());
        }
        return subTaskIds;
    }

    @Override
    public void updateSubTask(SubTask subTask) {
        String subTaskId = subTask.getSubTaskId();
        SubTask exist = this.subTaskMap.get(subTaskId);
        String mergeFeature = JsonUtil.merge((String)exist.getFeature(), (String)subTask.getFeature());
        String mergeRuntime = JsonUtil.merge((String)exist.getRuntimeParam(), (String)subTask.getRuntimeParam());
        String merge = JsonUtil.merge((String)JsonUtil.toJsonString((Object)exist), (String)JsonUtil.toJsonString((Object)subTask));
        SubTask newTask = (SubTask)JsonUtil.toObject((String)merge, SubTask.class);
        newTask.setFeature(mergeFeature);
        newTask.setRuntimeParam(mergeRuntime);
        this.subTaskMap.put(subTaskId, newTask);
    }

    @Override
    public SubTask getSubTask(String subTaskId) {
        return this.subTaskMap.get(subTaskId);
    }

    @Override
    public TaskSpecification getTaskSpecification(String taskCode) {
        return this.taskSpecificationMap.get(taskCode);
    }

    @Override
    public String createTaskSpecification(CreateSpecificationRequest createSpecificationRequest) {
        TaskSpecification taskSpecification = (TaskSpecification)BeanUtils.cloneProp((Object)createSpecificationRequest, TaskSpecification.class);
        this.taskSpecificationMap.put(taskSpecification.getTaskCode(), taskSpecification);
        return createSpecificationRequest.getTaskCode();
    }
}

