/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.dispatcher.http;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.processor.core.spi.dispatcher.SubDispatcherContext;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;

public class DispatchQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatchQueue.class);
    private static final int THRESHOLD = 8192;
    private ArrayBlockingQueue<SubDispatcherContext> queue = new ArrayBlockingQueue(8192);

    public SubDispatcherContext get() {
        try {
            return this.queue.take();
        }
        catch (Throwable e) {
            LOGGER.error("get failed, ", e);
            throw new RuntimeException(e);
        }
    }

    public void add(SubDispatcherContext dispatchSlice) {
        try {
            this.queue.add(dispatchSlice);
        }
        catch (Throwable e) {
            LOGGER.error("add failed, ", e);
            throw new RuntimeException(e);
        }
    }

    public void add(Collection<SubDispatcherContext> subDispatcherContexts) {
        int curQueueSize = this.queue.size();
        if (curQueueSize + subDispatcherContexts.size() > 8192) {
            String format = StringUtils.format((String)"addAll failed, max:{}, current:{}, addAll:{}", (Object[])new Object[]{8192, curQueueSize, subDispatcherContexts.size()});
            LOGGER.error(format);
            throw new RuntimeException(format);
        }
        for (SubDispatcherContext subDispatchPayload : subDispatcherContexts) {
            this.add(subDispatchPayload);
        }
    }
}

