/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.dispatcher.http;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.TaskIdUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.dispatcher.http.HttpDispatchRequest;
import com.alibaba.ageiport.processor.core.dispatcher.http.HttpDispatchResponse;
import com.alibaba.ageiport.processor.core.dispatcher.http.HttpDispatcher;
import com.alibaba.ageiport.processor.core.dispatcher.http.HttpDispatcherOptions;
import com.alibaba.ageiport.processor.core.executor.SubWorkerExecutor;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.spi.task.factory.SubTaskWorker;
import com.alibaba.ageiport.processor.core.spi.task.factory.SubTaskWorkerFactory;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationRegistry;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import java.util.List;

public class HttpDispatcherAgent
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(HttpDispatcher.class);
    private AgeiPort ageiPort;
    private HttpDispatcher dispatcher;
    private HttpDispatcherOptions options;

    public HttpDispatcherAgent(AgeiPort ageiPort, HttpDispatcher dispatcher) {
        this.ageiPort = ageiPort;
        this.dispatcher = dispatcher;
        this.options = dispatcher.getOptions();
    }

    private void dispatchSubTaskToLocal(String mainTaskId, List<Integer> subTaskNos) {
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(mainTaskId);
        TaskSpecificationRegistry taskSpecificationRegistry = this.ageiPort.getSpecificationRegistry();
        TaskSpec taskSpec = taskSpecificationRegistry.get(mainTask.getCode());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        SubTaskWorkerFactory workerFactory = spiSelector.selectExtension(taskSpec.getExecuteType(), taskSpec.getTaskType(), mainTask.getCode(), SubTaskWorkerFactory.class);
        for (Integer subTaskNo : subTaskNos) {
            String subTaskId = TaskIdUtil.genSubTaskId((String)mainTaskId, (Integer)subTaskNo);
            SubTask subTask = this.ageiPort.getTaskServerClient().getSubTask(subTaskId);
            SubTaskWorker worker = workerFactory.create(this.ageiPort, subTask);
            SubWorkerExecutor workerExecutor = this.ageiPort.getSubWorkerExecutor();
            workerExecutor.submit(worker);
        }
    }

    public void start() {
        this.vertx.createHttpServer().requestHandler(request -> {
            if ("/subTasks".equals(request.uri())) {
                request.body(event -> {
                    if (event.succeeded()) {
                        String requestJson = ((Buffer)event.result()).toString();
                        HttpDispatchRequest dispatchRequest = (HttpDispatchRequest)JsonUtil.toObject((String)requestJson, HttpDispatchRequest.class);
                        this.dispatchSubTaskToLocal(dispatchRequest.getMainTaskId(), dispatchRequest.getSubTaskNos());
                        HttpDispatchResponse dispatchResponse = new HttpDispatchResponse(true);
                        String responseJson = JsonUtil.toJsonString((Object)dispatchResponse);
                        request.response().end(responseJson);
                    } else {
                        HttpDispatchResponse dispatchResponse = new HttpDispatchResponse(false);
                        String responseJson = JsonUtil.toJsonString((Object)dispatchResponse);
                        request.response().end(responseJson);
                    }
                });
            } else {
                request.response().setStatusCode(404).end("");
            }
        }).listen(this.options.getPort().intValue());
    }
}

