/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.dispatcher.local;

import com.alibaba.ageiport.common.utils.TaskIdUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.dispatcher.local.LocalDispatcherOptions;
import com.alibaba.ageiport.processor.core.executor.MainWorkerExecutor;
import com.alibaba.ageiport.processor.core.executor.SubWorkerExecutor;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.processor.core.spi.dispatcher.Dispatcher;
import com.alibaba.ageiport.processor.core.spi.dispatcher.RootDispatcherContext;
import com.alibaba.ageiport.processor.core.spi.dispatcher.SubDispatcherContext;
import com.alibaba.ageiport.processor.core.spi.task.factory.MainTaskWorker;
import com.alibaba.ageiport.processor.core.spi.task.factory.MainTaskWorkerFactory;
import com.alibaba.ageiport.processor.core.spi.task.factory.SubTaskWorker;
import com.alibaba.ageiport.processor.core.spi.task.factory.SubTaskWorkerFactory;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationRegistry;
import java.util.List;

public class LocalDispatcher
implements Dispatcher {
    private AgeiPort ageiPort;
    private LocalDispatcherOptions options;

    public LocalDispatcher(AgeiPort ageiPort, LocalDispatcherOptions options) {
        this.ageiPort = ageiPort;
        this.options = options;
    }

    @Override
    public void dispatchMainTaskPrepare(RootDispatcherContext context) {
        String mainTaskId = context.getMainTaskId();
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(mainTaskId);
        TaskSpecificationRegistry taskSpecificationRegistry = this.ageiPort.getSpecificationRegistry();
        TaskSpec taskSpec = taskSpecificationRegistry.get(mainTask.getCode());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        MainTaskWorkerFactory workerFactory = spiSelector.selectExtension(taskSpec.getExecuteType(), taskSpec.getTaskType(), mainTask.getCode(), MainTaskWorkerFactory.class);
        MainTaskWorker worker = workerFactory.create(this.ageiPort, mainTask);
        worker.isReduce(false);
        MainWorkerExecutor workerExecutor = this.ageiPort.getMainWorkerExecutor();
        workerExecutor.submit(worker);
    }

    @Override
    public void dispatchSubTasks(SubDispatcherContext context) {
        String mainTaskId = context.getMainTaskId();
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(mainTaskId);
        TaskSpecificationRegistry taskSpecificationRegistry = this.ageiPort.getSpecificationRegistry();
        TaskSpec taskSpec = taskSpecificationRegistry.get(mainTask.getCode());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        SubTaskWorkerFactory workerFactory = spiSelector.selectExtension(taskSpec.getExecuteType(), taskSpec.getTaskType(), mainTask.getCode(), SubTaskWorkerFactory.class);
        List<Integer> subTaskNos = context.getSubTaskNos();
        for (Integer subTaskNo : subTaskNos) {
            String subTaskId = TaskIdUtil.genSubTaskId((String)mainTaskId, (Integer)subTaskNo);
            SubTask subTask = this.ageiPort.getTaskServerClient().getSubTask(subTaskId);
            SubTaskWorker worker = workerFactory.create(this.ageiPort, subTask);
            SubWorkerExecutor workerExecutor = this.ageiPort.getSubWorkerExecutor();
            workerExecutor.submit(worker);
        }
    }

    @Override
    public void dispatchMainTaskReduce(RootDispatcherContext context) {
        String mainTaskId = context.getMainTaskId();
        TaskServerClient taskServerClient = this.ageiPort.getTaskServerClient();
        MainTask mainTask = taskServerClient.getMainTask(mainTaskId);
        TaskSpecificationRegistry taskSpecificationRegistry = this.ageiPort.getSpecificationRegistry();
        TaskSpec taskSpec = taskSpecificationRegistry.get(mainTask.getCode());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        MainTaskWorkerFactory workerFactory = spiSelector.selectExtension(taskSpec.getExecuteType(), taskSpec.getTaskType(), mainTask.getCode(), MainTaskWorkerFactory.class);
        MainTaskWorker worker = workerFactory.create(this.ageiPort, mainTask);
        worker.isReduce(true);
        MainWorkerExecutor workerExecutor = this.ageiPort.getMainWorkerExecutor();
        workerExecutor.submit(worker);
    }
}

