/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.eventbus.local;

import com.alibaba.ageiport.common.concurrent.ThreadPoolUtil;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.processor.core.eventbus.local.LocalEventBusOptions;
import com.alibaba.ageiport.processor.core.eventbus.local.async.AsyncEventBus;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBus;
import java.util.EventListener;
import java.util.EventObject;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;

public class LocalEventBus
implements EventBus {
    public static final Logger LOGGER = LoggerFactory.getLogger(LocalEventBus.class);
    private AsyncEventBus eventBus;

    public LocalEventBus(LocalEventBusOptions options) {
        ExecutorService executorService = ThreadPoolUtil.createExecutor((String)"eb-local", (int)options.getCorePoolSize(), (int)options.getMaxPoolSize(), new ArrayBlockingQueue(options.getQueueSize()));
        this.eventBus = new AsyncEventBus(executorService);
    }

    @Override
    public void register(EventListener listener) {
        this.eventBus.register(listener);
    }

    @Override
    public void unregister(EventListener listener) {
        this.eventBus.unregister(listener);
    }

    @Override
    public void post(EventObject event) {
        LOGGER.info("local post event:{}", new Object[]{event});
        this.eventBus.post(event);
    }
}

