/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.eventbus.local.async;

import com.alibaba.ageiport.processor.core.eventbus.local.async.Dispatcher;
import com.alibaba.ageiport.processor.core.eventbus.local.async.Subscriber;
import com.alibaba.ageiport.processor.core.eventbus.local.async.SubscriberExceptionContext;
import com.alibaba.ageiport.processor.core.eventbus.local.async.SubscriberExceptionHandler;
import com.alibaba.ageiport.processor.core.eventbus.local.async.SubscriberRegistry;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    private static final Logger logger = LoggerFactory.getLogger((String)EventBus.class.getName());
    private final String identifier;
    private final Executor executor;
    private final SubscriberExceptionHandler exceptionHandler;
    private final SubscriberRegistry subscribers = new SubscriberRegistry(this);
    private final Dispatcher dispatcher;

    public EventBus(String identifier, Executor executor, Dispatcher dispatcher, SubscriberExceptionHandler exceptionHandler) {
        if (identifier == null) {
            throw new NullPointerException("identifier is null");
        }
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher is null");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler is null");
        }
        this.identifier = identifier;
        this.executor = executor;
        this.dispatcher = dispatcher;
        this.exceptionHandler = exceptionHandler;
    }

    public final String identifier() {
        return this.identifier;
    }

    final Executor executor() {
        return this.executor;
    }

    void handleSubscriberException(Throwable e, SubscriberExceptionContext context) {
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        try {
            this.exceptionHandler.handleException(e, context);
        }
        catch (Throwable e2) {
            logger.error("Exception {} thrown while handling exception: {}", new Object[]{e2, e, e2});
        }
    }

    public void register(Object object) {
        this.subscribers.register(object);
    }

    public void unregister(Object object) {
        this.subscribers.unregister(object);
    }

    public void post(Object event) {
        Iterator<Subscriber> eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            this.dispatcher.dispatch(event, eventSubscribers);
        }
    }

    static final class LoggingHandler
    implements SubscriberExceptionHandler {
        static final LoggingHandler INSTANCE = new LoggingHandler();
        private static final Logger logger = LoggerFactory.getLogger((String)LoggingHandler.class.getName());

        LoggingHandler() {
        }

        @Override
        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            logger.error(LoggingHandler.message(context), exception);
        }

        private static String message(SubscriberExceptionContext context) {
            Method method = context.getSubscriberMethod();
            return "Exception thrown by subscriber method " + method.getName() + '(' + method.getParameterTypes()[0].getName() + ')' + " on subscriber " + context.getSubscriber() + " when dispatching event: " + context.getEvent();
        }
    }
}

