/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.eventbus.local.async;

import com.alibaba.ageiport.processor.core.eventbus.local.async.EventBus;
import com.alibaba.ageiport.processor.core.eventbus.local.async.SubscriberExceptionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;

class Subscriber {
    private EventBus bus;
    final Object target;
    private final Method method;
    private final Executor executor;

    static Subscriber create(EventBus bus, Object listener, Method method) {
        return new SynchronizedSubscriber(bus, listener, method);
    }

    private Subscriber(EventBus bus, Object target, Method method) {
        this.bus = bus;
        this.target = target;
        this.method = method;
        method.setAccessible(true);
        this.executor = bus.executor();
    }

    final void dispatchEvent(Object event) {
        this.executor.execute(() -> {
            try {
                this.invokeSubscriberMethod(event);
            }
            catch (InvocationTargetException e) {
                this.bus.handleSubscriberException(e.getCause(), this.context(event));
            }
        });
    }

    void invokeSubscriberMethod(Object event) throws InvocationTargetException {
        try {
            if (event == null) {
                throw new NullPointerException("event is null");
            }
            this.method.invoke(this.target, event);
        }
        catch (IllegalArgumentException e) {
            throw new Error("Method rejected target/argument: " + event, e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Method became inaccessible: " + event, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    private SubscriberExceptionContext context(Object event) {
        return new SubscriberExceptionContext(this.bus, event, this.target, this.method);
    }

    public final int hashCode() {
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Subscriber) {
            Subscriber that = (Subscriber)obj;
            return this.target == that.target && this.method.equals(that.method);
        }
        return false;
    }

    static final class SynchronizedSubscriber
    extends Subscriber {
        private SynchronizedSubscriber(EventBus bus, Object target, Method method) {
            super(bus, target, method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void invokeSubscriberMethod(Object event) throws InvocationTargetException {
            SynchronizedSubscriber synchronizedSubscriber = this;
            synchronized (synchronizedSubscriber) {
                super.invokeSubscriberMethod(event);
            }
        }
    }
}

