/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.eventbus.local.async;

import com.alibaba.ageiport.common.utils.ReflectUtils;
import com.alibaba.ageiport.common.utils.TypeUtils;
import com.alibaba.ageiport.processor.core.eventbus.local.async.EventBus;
import com.alibaba.ageiport.processor.core.eventbus.local.async.Subscribe;
import com.alibaba.ageiport.processor.core.eventbus.local.async.Subscriber;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;

public final class SubscriberRegistry {
    private final ConcurrentMap<Class<?>, CopyOnWriteArraySet<Subscriber>> subscribers = new ConcurrentHashMap();
    private final EventBus bus;
    private static final ConcurrentMap<Class<?>, List<Method>> subscriberMethodsMap = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Set<Class<?>>> flattenHierarchyMap = new ConcurrentHashMap();

    public SubscriberRegistry(EventBus bus) {
        if (bus == null) {
            throw new NullPointerException("bus is null");
        }
        this.bus = bus;
    }

    void register(Object listener) {
        ConcurrentMap<Class<?>, Set<Subscriber>> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection eventMethodsInListener = (Collection)entry.getValue();
            CopyOnWriteArraySet eventSubscribers = this.subscribers.computeIfAbsent(eventType, key -> new CopyOnWriteArraySet());
            eventSubscribers.addAll(eventMethodsInListener);
        }
    }

    void unregister(Object listener) {
        ConcurrentMap<Class<?>, Set<Subscriber>> listenerMethods = this.findAllSubscribers(listener);
        for (Map.Entry entry : listenerMethods.entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection listenerMethodsForType = (Collection)entry.getValue();
            CopyOnWriteArraySet currentSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (currentSubscribers != null && currentSubscribers.removeAll(listenerMethodsForType)) continue;
            throw new IllegalArgumentException("missing event subscriber for an annotated method. Is " + listener + " registered?");
        }
    }

    Iterator<Subscriber> getSubscribers(Object event) {
        Set<Class<?>> eventTypes = SubscriberRegistry.flattenHierarchy(event.getClass());
        ArrayList subscriberIterators = new ArrayList(eventTypes.size());
        for (Class<?> eventType : eventTypes) {
            CopyOnWriteArraySet eventSubscribers = (CopyOnWriteArraySet)this.subscribers.get(eventType);
            if (eventSubscribers == null) continue;
            subscriberIterators.add(eventSubscribers.iterator());
        }
        List collect = subscriberIterators.stream().flatMap(iters -> {
            ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
            while (iters.hasNext()) {
                subscribers.add((Subscriber)iters.next());
            }
            return subscribers.stream();
        }).collect(Collectors.toList());
        return collect.iterator();
    }

    private ConcurrentMap<Class<?>, Set<Subscriber>> findAllSubscribers(Object listener) {
        ConcurrentHashMap methodsInListener = new ConcurrentHashMap();
        Class<?> clazz = listener.getClass();
        for (Method method : SubscriberRegistry.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            Set subscribers = methodsInListener.computeIfAbsent(eventType, key -> new HashSet());
            subscribers.add(Subscriber.create(this.bus, listener, method));
        }
        return methodsInListener;
    }

    private static List<Method> getAnnotatedMethods(Class<?> clazz) {
        List methods = (List)subscriberMethodsMap.get(clazz);
        if (methods != null) {
            return methods;
        }
        List<Method> annotatedMethodsNotCached = SubscriberRegistry.getAnnotatedMethodsNotCached(clazz);
        subscriberMethodsMap.put(clazz, annotatedMethodsNotCached);
        return annotatedMethodsNotCached;
    }

    private static List<Method> getAnnotatedMethodsNotCached(Class<?> clazz) {
        HashMap<MethodIdentifier, Method> identifiers = new HashMap<MethodIdentifier, Method>(8);
        for (Method method : ReflectUtils.getMethods(clazz)) {
            if (!method.isAnnotationPresent(Subscribe.class) || method.isSynthetic()) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("Method {} has @Subscribe annotation but has {} parameters.Subscriber methods must have exactly 1 parameter.");
            }
            MethodIdentifier ident = new MethodIdentifier(method);
            if (identifiers.containsKey(ident)) continue;
            identifiers.put(ident, method);
        }
        return identifiers.values().stream().collect(Collectors.toList());
    }

    static Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        Set classes = (Set)flattenHierarchyMap.get(concreteClass);
        if (classes != null) {
            return classes;
        }
        classes = TypeUtils.flattenHierarchy(concreteClass);
        flattenHierarchyMap.put(concreteClass, classes);
        return classes;
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            Object[] objects = new Object[]{this.name, this.parameterTypes};
            return Arrays.hashCode(objects);
        }

        public boolean equals(Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

