/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.executor;

import com.alibaba.ageiport.common.concurrent.Futures;
import com.alibaba.ageiport.common.concurrent.ListenableFuture;
import com.alibaba.ageiport.common.concurrent.ListeningExecutorService;
import com.alibaba.ageiport.common.concurrent.ThreadPoolUtil;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MainWorkerExecutor {
    public int timeoutMs;
    private ListeningExecutorService executor;

    public MainWorkerExecutor(AgeiPortOptions.MainWorkerExecutor options) {
        this.executor = ThreadPoolUtil.createListeningExecutor((String)options.getName(), (int)options.getCorePoolSize(), (int)options.getMaxPoolSize(), new LinkedBlockingQueue(options.getQueueSize()));
        this.timeoutMs = options.getTimeoutMs();
    }

    public ListenableFuture<?> submit(Runnable runnable) {
        ListenableFuture future = this.executor.submit(runnable);
        ListenableFuture timeoutFuture = Futures.withTimeout((ListenableFuture)future, (long)this.timeoutMs, (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)ThreadPoolUtil.scheduledExecutorService());
        return timeoutFuture;
    }
}

