/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.file.excel;

import com.alibaba.ageiport.common.collections.Lists;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.file.excel.ExcelWriteHandlerProvider;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeader;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.spi.file.FileContext;
import com.alibaba.ageiport.processor.core.spi.file.FileReader;
import com.alibaba.ageiport.processor.core.spi.task.factory.TaskContext;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class ExcelFileReader
implements FileReader {
    public static Logger logger = LoggerFactory.getLogger(ExcelFileReader.class);
    private AgeiPort ageiPort;
    private ColumnHeaders columnHeaders;
    private List<ExcelReadListener> readListeners;
    private FileContext fileContext;

    public ExcelFileReader(AgeiPort ageiPort, ColumnHeaders columnHeaders, FileContext fileContext) {
        this.ageiPort = ageiPort;
        this.columnHeaders = columnHeaders;
        this.readListeners = new ArrayList<ExcelReadListener>();
        this.fileContext = fileContext;
    }

    @Override
    public void read(InputStream inputStream) {
        ExcelTypeEnum excelTypeEnum = ExcelWriteHandlerProvider.getExcelTypeEnum(this.fileContext);
        ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).excelType(excelTypeEnum).build();
        List readSheets = excelReader.excelExecutor().sheetList();
        ArrayList<ReadSheet> sheetsNeedReads = new ArrayList<ReadSheet>();
        int sheetIndex = 0;
        for (ReadSheet readSheet : readSheets) {
            String sheetName = readSheet.getSheetName();
            if (sheetName != null && sheetName.startsWith("hidden_")) {
                logger.warn("ignore sheet, main:{}, sheetNo:{}, sheetName:{}", new Object[]{this.fileContext.getMainTask(), readSheet.getSheetNo(), sheetName});
                continue;
            }
            ExcelReadListener readListener = new ExcelReadListener(this.ageiPort, this.fileContext, this.columnHeaders);
            this.readListeners.add(readListener);
            readSheet.setCustomReadListenerList((List)Lists.newArrayList((Object[])new ReadListener[]{readListener}));
            Integer headerRowCount = this.columnHeaders.getHeaderRowCount(sheetIndex);
            readSheet.setHeadRowNumber(headerRowCount);
            sheetsNeedReads.add(readSheet);
            ++sheetIndex;
        }
        excelReader.read(sheetsNeedReads);
    }

    @Override
    public DataGroup finish() {
        DataGroup dataGroup = new DataGroup();
        ArrayList<DataGroup.Data> data = new ArrayList<DataGroup.Data>();
        for (ExcelReadListener listener : this.readListeners) {
            DataGroup.Data uploadData = listener.getData();
            if (uploadData == null) continue;
            data.add(uploadData);
        }
        dataGroup.setData(data);
        return dataGroup;
    }

    @Override
    public void close() {
    }

    public static class ExcelReadListener
    extends AnalysisEventListener<Map<Integer, Object>> {
        Logger log = LoggerFactory.getLogger(TaskContext.class);
        private AgeiPort ageiPort;
        private FileContext fileContext;
        private ColumnHeaders columnHeaders;
        private Map<Integer, List<String>> uploadHeaderNameKeys = new HashMap<Integer, List<String>>(4);
        private DataGroup.Data uploadData;
        private CountDownLatch countDownLatch;

        public ExcelReadListener(AgeiPort ageiPort, FileContext fileContext, ColumnHeaders columnHeaders) {
            this.ageiPort = ageiPort;
            this.columnHeaders = columnHeaders;
            this.fileContext = fileContext;
            this.countDownLatch = new CountDownLatch(1);
        }

        public void invoke(Map<Integer, Object> data, AnalysisContext context) {
            HashMap<String, Object> line = new HashMap<String, Object>(data.size() * 2);
            for (Map.Entry<Integer, Object> entry : data.entrySet()) {
                Integer column = entry.getKey();
                List<String> headers = this.uploadHeaderNameKeys.get(column);
                ColumnHeader columnHeader = this.columnHeaders.getColumnHeaderByHeaderName(headers);
                if (columnHeader == null) continue;
                String fieldName = columnHeader.getFieldName();
                if (columnHeader.getDynamicColumn().booleanValue()) {
                    Object o = line.get(fieldName);
                    if (o == null) {
                        o = new HashMap();
                        line.put(fieldName, o);
                        continue;
                    }
                    if (!(o instanceof Map)) continue;
                    Map map = (Map)o;
                    map.put(columnHeader.getDynamicColumnKey(), entry.getValue());
                    continue;
                }
                line.put(fieldName, entry.getValue());
            }
            for (Map.Entry<Integer, Object> entry : data.entrySet()) {
                line.put(entry.getKey().toString(), entry.getValue());
            }
            DataGroup.Item item = new DataGroup.Item();
            String sheetName = context.readSheetHolder().getSheetName();
            String sheetNo = context.readSheetHolder().getSheetNo().toString();
            Integer rowIndex = context.readRowHolder().getRowIndex();
            String groupName = sheetName + "@" + sheetNo;
            String code = groupName + "@" + rowIndex;
            item.setCode(code);
            item.setValues(line);
            this.uploadData.getItems().add(item);
        }

        public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
            if (this.uploadData == null) {
                String sheetName = context.readSheetHolder().getSheetName();
                String sheetNo = context.readSheetHolder().getSheetNo().toString();
                String groupName = sheetName + "@" + sheetNo;
                this.uploadData = new DataGroup.Data();
                this.uploadData.setCode(groupName);
                this.uploadData.setItems(new ArrayList<DataGroup.Item>());
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("_sheetNo", sheetNo);
                meta.put("_sheetName", sheetName);
                this.uploadData.setMeta(meta);
            }
            for (Map.Entry<Integer, String> entry : headMap.entrySet()) {
                Integer key = entry.getKey();
                List<String> headers = this.uploadHeaderNameKeys.get(key);
                if (headers == null) {
                    headers = new ArrayList<String>();
                    headers.add(entry.getValue());
                } else {
                    headers.add(entry.getValue());
                }
                this.uploadHeaderNameKeys.put(key, headers);
            }
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
            Map<String, String> meta = this.uploadData.getMeta();
            meta.put("_sheetUploadHeaders", JsonUtil.toJsonString(this.uploadHeaderNameKeys));
            this.countDownLatch.countDown();
        }

        public DataGroup.Data getData() {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.uploadData;
        }

        public Logger getLog() {
            return this.log;
        }

        public AgeiPort getAgeiPort() {
            return this.ageiPort;
        }

        public FileContext getFileContext() {
            return this.fileContext;
        }

        public ColumnHeaders getColumnHeaders() {
            return this.columnHeaders;
        }

        public Map<Integer, List<String>> getUploadHeaderNameKeys() {
            return this.uploadHeaderNameKeys;
        }

        public DataGroup.Data getUploadData() {
            return this.uploadData;
        }

        public CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }

        public void setLog(Logger log) {
            this.log = log;
        }

        public void setAgeiPort(AgeiPort ageiPort) {
            this.ageiPort = ageiPort;
        }

        public void setFileContext(FileContext fileContext) {
            this.fileContext = fileContext;
        }

        public void setColumnHeaders(ColumnHeaders columnHeaders) {
            this.columnHeaders = columnHeaders;
        }

        public void setUploadHeaderNameKeys(Map<Integer, List<String>> uploadHeaderNameKeys) {
            this.uploadHeaderNameKeys = uploadHeaderNameKeys;
        }

        public void setUploadData(DataGroup.Data uploadData) {
            this.uploadData = uploadData;
        }

        public void setCountDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }
    }
}

