/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.file.excel;

import com.alibaba.ageiport.common.io.FastByteArrayOutputStream;
import com.alibaba.ageiport.common.utils.IOUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.file.excel.ExcelWriteHandlerProvider;
import com.alibaba.ageiport.processor.core.file.excel.ExcelWriteHandlerProviderSpiConfig;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeader;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.spi.file.FileContext;
import com.alibaba.ageiport.processor.core.spi.file.FileWriter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.Closeable;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExcelFileWriter
implements FileWriter {
    private AgeiPort ageiPort;
    private ColumnHeaders columnHeaders;
    private FileContext fileContext;
    private Map<Integer, WriteSheet> writeSheetMap;
    private ExcelWriter excelWriter;
    private Map<String, Integer> sheetNameNoMap;
    ExcelWriteHandlerProviderSpiConfig providerSpiConfig;

    public ExcelFileWriter(AgeiPort ageiPort, ColumnHeaders columnHeaders, FileContext fileContext) {
        this.ageiPort = ageiPort;
        this.columnHeaders = columnHeaders;
        this.fileContext = fileContext;
        this.writeSheetMap = new HashMap<Integer, WriteSheet>();
        this.sheetNameNoMap = new HashMap<String, Integer>();
        AgeiPortOptions options = ageiPort.getOptions();
        Map<String, Map<String, String>> spiConfigs = options.getSpiConfigs();
        Map<String, String> providerConfigs = spiConfigs.get("ExcelWriteHandlerProvider");
        String configAsJson = JsonUtil.toJsonString(providerConfigs);
        this.providerSpiConfig = (ExcelWriteHandlerProviderSpiConfig)JsonUtil.toObject((String)configAsJson, ExcelWriteHandlerProviderSpiConfig.class);
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(ExcelWriteHandlerProvider.class);
        ExcelWriteHandlerProvider handlerProvider = (ExcelWriteHandlerProvider)extensionLoader.getExtension(this.providerSpiConfig.getExtensionName());
        this.excelWriter = handlerProvider.provideExcelWriter(ageiPort, columnHeaders, fileContext);
    }

    private void initSheetsByHeaders() {
        List groups = this.columnHeaders.getColumnHeaders().stream().map(s -> new AbstractMap.SimpleEntry<Integer, String>(s.getGroupIndex(), s.getGroupName())).distinct().collect(Collectors.toList());
        for (Map.Entry indexName : groups) {
            Integer sheetNo = (Integer)indexName.getKey() < 0 ? 0 : (Integer)indexName.getKey();
            String sheetName = (String)indexName.getValue();
            if (StringUtils.isEmpty((CharSequence)sheetName)) {
                sheetName = "sheet" + (sheetNo + 1);
            }
            if (this.sheetNameNoMap.containsKey(sheetName)) continue;
            List head = this.columnHeaders.getColumnHeaders().stream().filter(s -> s.getIgnoreHeader() == false).filter(s -> s.getGroupIndex().equals(sheetNo) || s.getGroupIndex().equals(-1)).map(ColumnHeader::getHeaderName).collect(Collectors.toList());
            ExcelWriterSheetBuilder sheetBuilder = (ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet().sheetNo(sheetNo).sheetName(sheetName).needHead(Boolean.valueOf(true))).head(head);
            ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(ExcelWriteHandlerProvider.class);
            ExcelWriteHandlerProvider handlerProvider = (ExcelWriteHandlerProvider)extensionLoader.getExtension(this.providerSpiConfig.getExtensionName());
            DataGroup.Data data = new DataGroup.Data();
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("_sheetNo", sheetNo.toString());
            meta.put("_sheetName", sheetName);
            data.setCode(sheetName);
            data.setMeta(meta);
            data.setItems(Collections.emptyList());
            List<WriteHandler> writeHandlerList = handlerProvider.provide(this.ageiPort, this.columnHeaders, this.fileContext, data);
            for (WriteHandler writeHandler : writeHandlerList) {
                sheetBuilder.registerWriteHandler(writeHandler);
            }
            WriteSheet writeSheet = sheetBuilder.build();
            this.writeSheetMap.put(sheetNo, writeSheet);
            this.sheetNameNoMap.put(sheetName, sheetNo);
            this.excelWriter.writeContext().currentSheet(writeSheet, WriteTypeEnum.ADD);
        }
    }

    @Override
    public void write(DataGroup fileData) {
        for (DataGroup.Data data : fileData.getData()) {
            Integer sheetNo;
            String sheetName = "sheet1";
            Map<String, String> meta = data.getMeta();
            if (meta == null || !meta.containsKey("_sheetName")) {
                if (data.getCode() != null) {
                    sheetName = data.getCode();
                }
            } else {
                sheetName = meta.get("_sheetName");
            }
            if (meta == null || !meta.containsKey("_sheetNo")) {
                if (!this.sheetNameNoMap.containsKey(sheetName)) {
                    int size = this.sheetNameNoMap.size();
                    this.sheetNameNoMap.put(sheetName, size);
                }
                sheetNo = this.sheetNameNoMap.get(sheetName);
            } else {
                sheetNo = Integer.parseInt(meta.get("_sheetNo"));
            }
            if (!this.writeSheetMap.containsKey(sheetNo)) {
                List head = this.columnHeaders.getColumnHeaders().stream().filter(s -> s.getIgnoreHeader() == false).filter(s -> s.getGroupIndex().equals(sheetNo) || s.getGroupIndex().equals(-1)).map(ColumnHeader::getHeaderName).collect(Collectors.toList());
                ExcelWriterSheetBuilder sheetBuilder = (ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet().sheetNo(sheetNo).sheetName(sheetName).needHead(Boolean.valueOf(true))).head(head);
                ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(ExcelWriteHandlerProvider.class);
                ExcelWriteHandlerProvider handlerProvider = (ExcelWriteHandlerProvider)extensionLoader.getExtension(this.providerSpiConfig.getExtensionName());
                List<WriteHandler> writeHandlerList = handlerProvider.provide(this.ageiPort, this.columnHeaders, this.fileContext, data);
                for (WriteHandler writeHandler : writeHandlerList) {
                    sheetBuilder.registerWriteHandler(writeHandler);
                }
                WriteSheet writeSheet = sheetBuilder.build();
                this.writeSheetMap.put(sheetNo, writeSheet);
                this.excelWriter.writeContext().currentSheet(writeSheet, WriteTypeEnum.ADD);
            }
            WriteSheet writeSheet = this.writeSheetMap.get(sheetNo);
            List<List<Object>> lines = this.resolve(this.columnHeaders, data, sheetNo);
            this.excelWriter.write(lines, writeSheet);
        }
    }

    @Override
    public InputStream finish() {
        this.initSheetsByHeaders();
        WriteContext writeContext = this.excelWriter.writeContext();
        FastByteArrayOutputStream outputStream = (FastByteArrayOutputStream)writeContext.writeWorkbookHolder().getOutputStream();
        this.excelWriter.finish();
        return outputStream.getInputStream();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.excelWriter);
    }

    List<List<Object>> resolve(ColumnHeaders columnHeaders, DataGroup.Data groupData, Integer groupIndex) {
        List<DataGroup.Item> items = groupData.getItems();
        ArrayList<List<Object>> data = new ArrayList<List<Object>>(items.size());
        for (DataGroup.Item item : items) {
            Map<String, Object> values = item.getValues();
            ArrayList<Object> result = new ArrayList<Object>(values.size());
            for (ColumnHeader columnHeader : columnHeaders.getColumnHeaders()) {
                if (columnHeader.getIgnoreHeader().booleanValue() || columnHeader.getGroupIndex() >= 0 && !columnHeader.getGroupIndex().equals(groupIndex)) continue;
                String fieldName = columnHeader.getFieldName();
                Object value = values.get(fieldName);
                if (columnHeader.getDynamicColumn().booleanValue()) {
                    Map map = (Map)value;
                    Object o = map.get(columnHeader.getDynamicColumnKey());
                    result.add(o);
                    continue;
                }
                result.add(value);
            }
            data.add(result);
        }
        return data;
    }
}

