/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.file.excel;

import com.alibaba.ageiport.common.io.FastByteArrayOutputStream;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.ext.arch.SPI;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.spi.file.FileContext;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.handler.WriteHandler;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@SPI
public interface ExcelWriteHandlerProvider {
    public List<WriteHandler> provide(AgeiPort var1, ColumnHeaders var2, FileContext var3, DataGroup.Data var4);

    default public ExcelWriter provideExcelWriter(AgeiPort ageiPort, ColumnHeaders columnHeaders, FileContext fileContext) {
        FastByteArrayOutputStream output = new FastByteArrayOutputStream(10240);
        ExcelTypeEnum excelTypeEnum = ExcelWriteHandlerProvider.getExcelTypeEnum(fileContext);
        return EasyExcel.write((OutputStream)output).excelType(excelTypeEnum).build();
    }

    @NotNull
    public static ExcelTypeEnum getExcelTypeEnum(FileContext fileContext) {
        String fileType;
        String runtimeParam = fileContext.getMainTask().getRuntimeParam();
        Map runtimeMap = JsonUtil.toMap((String)runtimeParam);
        if (runtimeMap == null) {
            fileType = "xlsx";
        } else {
            fileType = (String)runtimeMap.get("fileType");
            if (fileType == null) {
                fileType = "xlsx";
            }
        }
        if (!fileType.startsWith(".")) {
            fileType = "." + fileType;
        }
        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.XLSX;
        for (ExcelTypeEnum value : ExcelTypeEnum.values()) {
            if (!value.getValue().equals(fileType)) continue;
            excelTypeEnum = value;
        }
        return excelTypeEnum;
    }
}

