/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.file.excel.style;

import com.alibaba.ageiport.common.utils.CollectionUtils;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeader;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class CellSelectorWriteHandler
implements SheetWriteHandler {
    private Map<Integer, List<String>> selectorMap = new HashMap<Integer, List<String>>();
    private ColumnHeaders columnHeaders;
    private DataGroup.Data data;

    public CellSelectorWriteHandler(ColumnHeaders columnHeaders, DataGroup.Data data) {
        this.columnHeaders = columnHeaders;
        List<ColumnHeader> headers = columnHeaders.getColumnHeaders();
        for (ColumnHeader header : headers) {
            this.selectorMap.put(header.getIndex(), header.getValues());
        }
        this.data = data;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        if (MapUtils.isEmpty(this.selectorMap)) {
            return;
        }
        Integer headerRowCount = this.columnHeaders.getHeaderRowCount(writeSheetHolder.getSheetNo());
        Integer sheetNo = writeSheetHolder.getSheetNo();
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        Sheet sheet = writeSheetHolder.getSheet();
        int lineCount = this.data.getItems().size();
        int lastRow = lineCount + headerRowCount;
        List<ColumnHeader> headersByGroup = this.columnHeaders.getHeadersByGroup(sheetNo);
        int index = 0;
        for (ColumnHeader columnHeader : headersByGroup) {
            if (CollectionUtils.isNotEmpty(columnHeader.getValues())) {
                CellSelectorWriteHandler.setLongHSSFValidation(workbook, sheet, columnHeader.getValues(), headerRowCount, lastRow, index);
            }
            ++index;
        }
    }

    public static void setLongHSSFValidation(Workbook workbook, Sheet sheet, List<String> deptList, int firstRow, int lastRow, int colNum) {
        String hiddenName = "hidden_" + sheet.getSheetName() + "_col_" + colNum;
        Sheet hidden = workbook.createSheet(hiddenName);
        int sheetIndex1 = workbook.getSheetIndex(hidden);
        int length = deptList.size();
        for (int i = 0; i < length; ++i) {
            hidden.createRow(lastRow + i).createCell(colNum).setCellValue(deptList.get(i));
        }
        Name category1Name = workbook.createName();
        category1Name.setNameName(hiddenName);
        category1Name.setRefersToFormula(hiddenName + "!A1:A" + (deptList.size() + lastRow));
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createFormulaListConstraint(hiddenName);
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, colNum, colNum);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
        workbook.setSheetHidden(sheetIndex1, true);
    }
}

