/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.file.store;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.IOUtils;
import com.alibaba.ageiport.ext.file.store.FileStore;
import com.alibaba.ageiport.processor.core.file.store.LocalFileStoreOptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class LocalFileStore
implements FileStore {
    private static Logger log = LoggerFactory.getLogger(LocalFileStore.class);
    private String basePath;

    public LocalFileStore(LocalFileStoreOptions options) {
        this.basePath = options.getBasePath();
        File folder = new File(this.basePath);
        if (!folder.exists() || !folder.isDirectory()) {
            folder.mkdirs();
        }
    }

    public void save(String path, InputStream inputStream, Map<String, Object> runtimeParams) {
        String filePath = this.basePath + path;
        File file = new File(filePath);
        FileOutputStream downloadFile = null;
        try {
            int index;
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] bytes = new byte[1024];
            downloadFile = new FileOutputStream(filePath);
            while ((index = inputStream.read(bytes)) != -1) {
                downloadFile.write(bytes, 0, index);
                downloadFile.flush();
            }
            downloadFile.close();
        }
        catch (IOException e) {
            try {
                log.error("LocalFileStore save failed, path:{}");
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(downloadFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)downloadFile);
    }

    public InputStream get(String path, Map<String, Object> runtimeParams) {
        String filePath = this.basePath + path;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String path, Map<String, Object> runtimeParams) {
        String filePath = this.basePath + path;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        file.delete();
    }

    public boolean exists(String path, Map<String, Object> runtimeParams) {
        String filePath = this.basePath + path;
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }
}

