/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.model.core.impl;

import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeader;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnHeadersImpl
implements ColumnHeaders {
    private static final long serialVersionUID = 6643692043129727292L;
    private List<ColumnHeader> columnHeaders;
    private Map<String, ColumnHeader> fieldNameIndexMap;
    private Map<Integer, ColumnHeader> columnIndexIndexMap;
    private Map<String, ColumnHeader> headerNameKeyIndexMap;
    private Map<List<String>, ColumnHeader> headerNameIndexMap;
    private Map<Integer, Map<Integer, ColumnHeader>> groupIndexMap;

    public ColumnHeadersImpl() {
    }

    public ColumnHeadersImpl(List<ColumnHeader> columnHeaders) {
        this.loadColumnHeaders(columnHeaders);
    }

    private void loadColumnHeaders(List<ColumnHeader> columnHeaders) {
        this.columnHeaders = columnHeaders;
        this.fieldNameIndexMap = new HashMap<String, ColumnHeader>(columnHeaders.size() * 2);
        this.columnIndexIndexMap = new HashMap<Integer, ColumnHeader>(columnHeaders.size() * 2);
        this.headerNameIndexMap = new HashMap<List<String>, ColumnHeader>(columnHeaders.size() * 2);
        this.headerNameKeyIndexMap = new HashMap<String, ColumnHeader>(columnHeaders.size() * 2);
        ArrayList<Integer> groupIndex = new ArrayList<Integer>();
        for (ColumnHeader columnHeader : columnHeaders) {
            this.fieldNameIndexMap.put(columnHeader.getFieldName(), columnHeader);
            this.columnIndexIndexMap.put(columnHeader.getIndex(), columnHeader);
            this.headerNameIndexMap.put(columnHeader.getHeaderName(), columnHeader);
            this.headerNameKeyIndexMap.put(columnHeader.getHeaderNameKey(), columnHeader);
            if (groupIndex.contains(columnHeader.getGroupIndex())) continue;
            groupIndex.add(columnHeader.getGroupIndex());
        }
        groupIndex.sort(Comparator.comparingInt(o -> o));
        this.groupIndexMap = new HashMap<Integer, Map<Integer, ColumnHeader>>(4);
        if (groupIndex.size() == 1 && (Integer)groupIndex.get(0) == -1) {
            Map headerMap = this.groupIndexMap.computeIfAbsent(0, k -> new HashMap());
            for (ColumnHeader columnHeader : columnHeaders) {
                headerMap.put(headerMap.size(), columnHeader);
            }
        } else {
            for (Integer n : groupIndex) {
                if (n == -1) continue;
                Map headerMap = this.groupIndexMap.computeIfAbsent(n, k -> new HashMap());
                for (ColumnHeader columnHeader : columnHeaders) {
                    if (columnHeader.getGroupIndex() != -1 && !columnHeader.getGroupIndex().equals(n)) continue;
                    headerMap.put(headerMap.size(), columnHeader);
                }
            }
        }
    }

    @Override
    public List<ColumnHeader> getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public ColumnHeader getColumnHeaderByFieldName(String fieldName) {
        return this.fieldNameIndexMap.get(fieldName);
    }

    @Override
    public ColumnHeader getColumnHeaderByHeaderName(List<String> headerName) {
        return this.headerNameIndexMap.get(headerName);
    }

    @Override
    public ColumnHeader getColumnHeaderByHeaderNameKey(String headerNameKey) {
        return this.headerNameKeyIndexMap.get(headerNameKey);
    }

    @Override
    public ColumnHeader getHeaderByIndex(Integer index) {
        return this.columnIndexIndexMap.get(index);
    }

    @Override
    public Integer getHeaderRowCount(Integer groupIndex) {
        Integer max = 1;
        for (ColumnHeader columnHeader : this.columnHeaders) {
            Integer headerRowCount;
            if (columnHeader.getGroupIndex() != -1 && !columnHeader.getGroupIndex().equals(groupIndex) || (headerRowCount = columnHeader.maxHeaderRowCount()) <= max) continue;
            max = headerRowCount;
        }
        return max;
    }

    @Override
    public List<ColumnHeader> getHeadersByGroup(Integer groupIndex) {
        Map<Integer, ColumnHeader> headerMap = this.groupIndexMap.get(groupIndex);
        Collection<ColumnHeader> values = headerMap.values();
        return new ArrayList<ColumnHeader>(values);
    }

    @Override
    public ColumnHeader getHeaderByGroupAndColumn(Integer groupIndex, Integer columnIndex) {
        return this.groupIndexMap.get(groupIndex).get(columnIndex);
    }

    @Override
    public void fromJson(String json) {
        List columnHeaderList = JsonUtil.toArrayObject((String)json, ColumnHeader.class);
        this.loadColumnHeaders(columnHeaderList);
    }

    @Override
    public String toJson() {
        return JsonUtil.toJsonString(this.columnHeaders);
    }
}

