/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.convertor;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Model {
    default public Map<String, Object> toMap() {
        return Model.changeToMap(this, true);
    }

    default public Map<String, Object> toMap(Boolean exceptStream) {
        return Model.changeToMap(this, exceptStream);
    }

    public static Map<String, Object> toMap(Object object) {
        return Model.toMap(object, true);
    }

    public static Map<String, Object> toMap(Object object, Boolean exceptStream) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (null != object && object instanceof Map) {
            return (Map)object;
        }
        if (null == object) {
            return map;
        }
        map = Model.changeToMap(object, exceptStream);
        return map;
    }

    public static Map<String, Object> changeToMap(Object object, Boolean exceptStream) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                String key = field.getName();
                if (null != field.get(object) && List.class.isAssignableFrom(field.get(object).getClass())) {
                    List arrayField = (List)field.get(object);
                    ArrayList<Object> fieldList = new ArrayList<Object>();
                    for (int i = 0; i < arrayField.size(); ++i) {
                        fieldList.add(Model.parseObject(arrayField.get(i)));
                    }
                    map.put(key, fieldList);
                } else if (null != field.get(object) && Model.class.isAssignableFrom(field.get(object).getClass())) {
                    map.put(key, Model.toMap(field.get(object), exceptStream));
                } else if (null != field.get(object) && Map.class.isAssignableFrom(field.get(object).getClass())) {
                    Map valueMap = (Map)field.get(object);
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    for (Map.Entry entry : valueMap.entrySet()) {
                        result.put((String)entry.getKey(), Model.parseObject(entry.getValue()));
                    }
                    map.put(key, result);
                } else {
                    if (exceptStream.booleanValue() && null != field.get(object) && InputStream.class.isAssignableFrom(field.get(object).getClass()) || exceptStream.booleanValue() && null != field.get(object) && OutputStream.class.isAssignableFrom(field.get(object).getClass())) continue;
                    map.put(key, field.get(object));
                }
                field.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return map;
    }

    public static Object parseObject(Object o) {
        if (null == o) {
            return o;
        }
        Class<?> clazz = o.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            List list = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : list) {
                result.add(Model.parseObject(object));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)o;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), Model.parseObject(entry.getValue()));
            }
            return result;
        }
        if (Model.class.isAssignableFrom(clazz)) {
            return ((Model)o).toMap(false);
        }
        return o;
    }

    public static Object buildObject(Object o, Class self, Type subType) {
        Class<?> valueClass = o.getClass();
        if (Map.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            Map valueMap = (Map)o;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : valueMap.entrySet()) {
                if (null == subType || subType instanceof WildcardType) {
                    result.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                if (subType instanceof Class) {
                    result.put((String)entry.getKey(), Model.buildObject(entry.getValue(), (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.put((String)entry.getKey(), Model.buildObject(entry.getValue(), (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (List.class.isAssignableFrom(self) && List.class.isAssignableFrom(valueClass)) {
            List valueList = (List)o;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object object : valueList) {
                if (null == subType || subType instanceof WildcardType) {
                    result.add(object);
                    continue;
                }
                if (subType instanceof Class) {
                    result.add(Model.buildObject(object, (Class)subType, null));
                    continue;
                }
                ParameterizedType parameterizedType = (ParameterizedType)subType;
                Type[] types = parameterizedType.getActualTypeArguments();
                result.add(Model.buildObject(object, (Class)parameterizedType.getRawType(), types[types.length - 1]));
            }
            return result;
        }
        if (Model.class.isAssignableFrom(self) && Map.class.isAssignableFrom(valueClass)) {
            try {
                return Model.toModel((Map)o, (Model)self.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return o;
    }

    public static Type getType(Field field, int index) {
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        Type actualTypeArgument = actualTypeArguments[index];
        return actualTypeArgument;
    }

    public static <T> T toModel(Map<String, ?> map, T model) {
        T result = model;
        for (Field field : result.getClass().getDeclaredFields()) {
            String key;
            Object value;
            if (Modifier.isStatic(field.getModifiers()) || (value = map.get(key = field.getName())) == null) continue;
            field.setAccessible(true);
            result = Model.setModelField(result, field, value, false);
            field.setAccessible(false);
        }
        return result;
    }

    public static <T> T setModelField(T model, Field field, Object value, boolean userBuild) {
        try {
            Class<?> clazz = field.getType();
            Object resultValue = Model.parseNumber(value, clazz);
            T result = model;
            if (Model.class.isAssignableFrom(clazz)) {
                Object data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (userBuild) {
                    field.set(result, Model.build(Model.toMap(resultValue, false), (Model)data));
                } else if (!userBuild && Map.class.isAssignableFrom(resultValue.getClass())) {
                    field.set(result, Model.toModel((Map)resultValue, (Model)data));
                } else {
                    field.set(result, resultValue);
                }
            } else if (Map.class.isAssignableFrom(clazz)) {
                field.set(result, Model.buildObject(resultValue, Map.class, Model.getType(field, 1)));
            } else if (List.class.isAssignableFrom(clazz)) {
                field.set(result, Model.buildObject(resultValue, List.class, Model.getType(field, 0)));
            } else {
                field.set(result, Model.confirmType(clazz, resultValue));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <T> T build(Map<String, ?> map, T model) {
        T result = model;
        for (Field field : model.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            String key = field.getName();
            Object value = map.get(key);
            result = Model.setModelField(result, field, value, true);
            field.setAccessible(false);
        }
        return result;
    }

    public static Object parseNumber(Object value, Class clazz) {
        if (value instanceof Double && (clazz == Long.class || clazz == Long.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.longValue();
        }
        if (value instanceof Double && (clazz == Integer.class || clazz == Integer.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return bigDecimal.intValue();
        }
        if (value instanceof Double && (clazz == Float.class || clazz == Float.TYPE)) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            return Float.valueOf(bigDecimal.floatValue());
        }
        return value;
    }

    public static Map<String, Object> buildMap(Model model) {
        if (null == model) {
            return null;
        }
        return model.toMap();
    }

    public static Object confirmType(Class expect, Object object) {
        if (String.class.isAssignableFrom(expect)) {
            if (object instanceof Number || object instanceof Boolean) {
                return object.toString();
            }
        } else if (Boolean.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                return Boolean.parseBoolean(String.valueOf(object));
            }
            if (object instanceof Integer) {
                if (object.toString().equals("1")) {
                    return true;
                }
                if (object.toString().equals("0")) {
                    return false;
                }
            }
        } else if (Integer.class.isAssignableFrom(expect)) {
            if (object instanceof String) {
                return Integer.parseInt(object.toString());
            }
            if (object instanceof Long && (Long)object <= Integer.MAX_VALUE) {
                return Integer.parseInt(object.toString());
            }
        } else if (Long.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Integer) {
                return Long.parseLong(object.toString());
            }
        } else if (Float.class.isAssignableFrom(expect)) {
            if (object instanceof String || object instanceof Integer || object instanceof Long) {
                return Float.valueOf(Float.parseFloat(object.toString()));
            }
            if (object instanceof Double && (Double)object <= 3.4028234663852886E38) {
                return Float.valueOf(Float.parseFloat(object.toString()));
            }
        } else if (Double.class.isAssignableFrom(expect) && (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Float)) {
            return Double.parseDouble(object.toString());
        }
        return object;
    }
}

