/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.dispatcher;

import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.spi.dispatcher.Dispatcher;
import com.alibaba.ageiport.processor.core.spi.dispatcher.DispatcherFactory;
import com.alibaba.ageiport.processor.core.spi.dispatcher.DispatcherOptions;

public class DispatcherManager {
    private AgeiPort ageiPort;
    private Dispatcher localDispatcher;
    private Dispatcher clusterDispatcher;

    public DispatcherManager(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        AgeiPortOptions options = ageiPort.getOptions();
        DispatcherOptions localDispatcherOptions = options.getLocal().getDispatcherOptions();
        DispatcherFactory localDispatcherFactory = (DispatcherFactory)ExtensionLoader.getExtensionLoader(DispatcherFactory.class).getExtension(localDispatcherOptions.type());
        this.localDispatcher = localDispatcherFactory.create(ageiPort, localDispatcherOptions);
        DispatcherOptions clusterDispatcherOptions = options.getCluster().getDispatcherOptions();
        DispatcherFactory clusterDispatcherFactory = (DispatcherFactory)ExtensionLoader.getExtensionLoader(DispatcherFactory.class).getExtension(clusterDispatcherOptions.type());
        this.clusterDispatcher = clusterDispatcherFactory.create(ageiPort, clusterDispatcherOptions);
    }

    public Dispatcher getDispatcher(String type) {
        if ("STANDALONE".equals(type)) {
            return this.localDispatcher;
        }
        return this.clusterDispatcher;
    }
}

