/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.eventbus;

import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBus;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBusFactory;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBusOptions;

public class EventBusManager {
    private AgeiPort ageiPort;
    private EventBus localEventBus;
    private EventBus clusterEventBus;

    public EventBusManager(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        AgeiPortOptions options = ageiPort.getOptions();
        EventBusOptions localEventBusOptions = options.getLocal().getEventBusOptions();
        EventBusFactory localEventBusFactory = (EventBusFactory)ExtensionLoader.getExtensionLoader(EventBusFactory.class).getExtension(localEventBusOptions.type());
        this.localEventBus = localEventBusFactory.create(ageiPort, localEventBusOptions);
        EventBusOptions clusterEventBusOptions = options.getCluster().getEventBusOptions();
        EventBusFactory clusterDispatcherFactory = (EventBusFactory)ExtensionLoader.getExtensionLoader(EventBusFactory.class).getExtension(clusterEventBusOptions.type());
        this.clusterEventBus = clusterDispatcherFactory.create(ageiPort, clusterEventBusOptions);
    }

    public EventBus getEventBus(String type) {
        if ("CLUSTER".equals(type)) {
            return this.clusterEventBus;
        }
        return this.localEventBus;
    }
}

