/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.service;

import com.alibaba.ageiport.common.Version;
import com.alibaba.ageiport.common.feature.FeatureUtils;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.constants.MainTaskFeatureKeys;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.spi.client.CreateMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.processor.core.spi.service.SyncExtensionApiParam;
import com.alibaba.ageiport.processor.core.spi.service.SyncExtensionApiResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressResult;
import com.alibaba.ageiport.processor.core.spi.service.TaskService;
import com.alibaba.ageiport.processor.core.spi.sync.SyncExtension;
import com.alibaba.ageiport.processor.core.spi.task.factory.TaskContext;
import com.alibaba.ageiport.processor.core.spi.task.monitor.MainTaskProgress;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressService;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationRegistry;

public class TaskServiceImpl
implements TaskService {
    Logger log = LoggerFactory.getLogger(TaskContext.class);
    private final AgeiPort ageiPort;

    public TaskServiceImpl(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
    }

    @Override
    public TaskExecuteResult executeTask(TaskExecuteParam param) {
        try {
            String code = param.getTaskSpecificationCode();
            TaskSpecificationRegistry registry = this.ageiPort.getSpecificationRegistry();
            TaskSpec taskSpec = registry.get(code);
            if (taskSpec == null) {
                this.log.error("not found TaskSpec in registry, for code:{}, please check config", new Object[]{code});
                throw new IllegalArgumentException("There is no TaskSpec for code:" + code);
            }
            String executeType = taskSpec.getExecuteType();
            String taskType = taskSpec.getTaskType();
            CreateMainTaskRequest createMainTaskRequest = (CreateMainTaskRequest)BeanUtils.cloneProp((Object)param, CreateMainTaskRequest.class);
            createMainTaskRequest.setCode(param.getTaskSpecificationCode());
            createMainTaskRequest.setExecuteType(executeType);
            createMainTaskRequest.setType(taskType);
            createMainTaskRequest.setName(taskSpec.getTaskName());
            createMainTaskRequest.setHost(this.ageiPort.getClusterManager().getLocalNode().getHost());
            String feature = createMainTaskRequest.getFeature();
            feature = FeatureUtils.putFeature((String)feature, MainTaskFeatureKeys.VERSION, (Object)Version.getVersion());
            feature = FeatureUtils.putFeature((String)feature, MainTaskFeatureKeys.LABELS, (Object)JsonUtil.toJsonString(param.getLabels()));
            feature = FeatureUtils.putFeature((String)feature, MainTaskFeatureKeys.INPUT_FILE_KEY, (Object)param.getInputFileKey());
            createMainTaskRequest.setFeature(feature);
            TaskServerClient taskServerClient = this.ageiPort.getTaskServerClient();
            String mainTaskId = taskServerClient.createMainTask(createMainTaskRequest);
            MainTask mainTask = taskServerClient.getMainTask(mainTaskId);
            this.ageiPort.getMainTaskCallback().afterCreated(mainTask);
            this.ageiPort.getTaskAcceptor().accept(mainTask);
            TaskExecuteResult response = new TaskExecuteResult();
            response.setSuccess(true);
            response.setMainTaskId(mainTaskId);
            return response;
        }
        catch (Throwable e) {
            this.log.error("TaskService#executeTask failed, request:{}", new Object[]{param, e});
            TaskExecuteResult response = new TaskExecuteResult();
            response.setSuccess(false);
            response.setErrorMessage(e.getMessage());
            return response;
        }
    }

    @Override
    public TaskProgressResult getTaskProgress(TaskProgressParam param) {
        try {
            String mainTaskId = param.getMainTaskId();
            TaskProgressService taskProgressService = this.ageiPort.getTaskProgressService();
            MainTaskProgress taskProgress = taskProgressService.getTaskProgress(mainTaskId);
            TaskProgressResult response = (TaskProgressResult)BeanUtils.cloneProp((Object)taskProgress, TaskProgressResult.class);
            return response;
        }
        catch (Throwable e) {
            this.log.error("TaskServiceImpl#getTaskProgress , param:{}", new Object[]{param, e});
            TaskProgressResult taskProgressResult = new TaskProgressResult();
            taskProgressResult.setSuccess(false);
            taskProgressResult.setErrorMessage(e.getMessage());
            return taskProgressResult;
        }
    }

    @Override
    public SyncExtensionApiResult executeSyncExtension(SyncExtensionApiParam param) {
        try {
            String syncExtensionApiCode = param.getSyncExtensionApiCode();
            ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(SyncExtension.class);
            SyncExtension syncExtension = (SyncExtension)extensionLoader.getExtension(syncExtensionApiCode);
            SyncExtensionApiResult result = syncExtension.execute(this.ageiPort, param);
            return result;
        }
        catch (Throwable e) {
            this.log.error("TaskServiceImpl#getTaskProgress, param:{}", new Object[]{param, e});
            SyncExtensionApiResult syncExtensionApiResult = new SyncExtensionApiResult();
            syncExtensionApiResult.setSuccess(false);
            syncExtensionApiResult.setErrorMessage(e.getMessage());
            return syncExtensionApiResult;
        }
    }
}

