/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.task.factory;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.processor.core.Context;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBus;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskStageEvent;
import com.alibaba.ageiport.processor.core.spi.task.stage.Stage;

public interface TaskContext
extends Context {
    public static final Logger logger = LoggerFactory.getLogger(TaskContext.class);

    public MainTask getMainTask();

    public SubTask getSubTask();

    public void setMainTask(MainTask var1);

    public void setTaskSpec(TaskSpec var1);

    public TaskSpec getTaskSpec();

    public BizUser getBizUser();

    public void setBizUser(BizUser var1);

    public void save();

    public Stage getStage();

    public void setStage(Stage var1);

    default public Stage goNextStage() {
        Stage current = this.getStage();
        Stage next = current.next();
        this.setStage(next);
        return current;
    }

    public Long getStageTimestamp(String var1);

    default public void goNextStageEventNew() {
        SubTask subTask;
        MainTask mainTask = this.getMainTask();
        String executeType = mainTask.getExecuteType();
        EventBus eventBus = this.getAgeiPort().getEventBusManager().getEventBus(executeType);
        Stage oldStage = this.goNextStage();
        Stage newStage = this.getStage();
        Long oldStageTimestamp = this.getStageTimestamp(oldStage.getCode());
        Long newStageTimestamp = this.getStageTimestamp(newStage.getCode());
        Long cost = null;
        if (oldStageTimestamp != null && newStageTimestamp != null) {
            cost = System.currentTimeMillis() - oldStageTimestamp;
        }
        if ((subTask = this.getSubTask()) == null) {
            eventBus.post(TaskStageEvent.mainTaskEvent(mainTask.getMainTaskId(), newStage, cost, mainTask.getSubTotalCount()));
        } else {
            eventBus.post(TaskStageEvent.subTaskEvent(subTask.getSubTaskId(), newStage, cost));
        }
    }

    default public void eventCurrentStage() {
        MainTask mainTask = this.getMainTask();
        String executeType = mainTask.getExecuteType();
        EventBus eventBus = this.getAgeiPort().getEventBusManager().getEventBus(executeType);
        Stage newStage = this.getStage();
        SubTask subTask = this.getSubTask();
        if (subTask == null) {
            eventBus.post(TaskStageEvent.mainTaskEvent(mainTask.getMainTaskId(), newStage, null, mainTask.getSubTotalCount()));
        } else {
            eventBus.post(TaskStageEvent.subTaskEvent(subTask.getSubTaskId(), newStage, null));
        }
    }

    default public void assertCurrentStage(String stageCode) {
        if (!stageCode.equals(this.getStage().getCode())) {
            String error = StringUtils.format((String)"error task stage, context:{}, expect:{}", (Object[])new Object[]{this.getStage().getCode(), stageCode});
            throw new IllegalStateException(error);
        }
    }

    default public void assertCurrentStage(Stage stage) {
        this.assertCurrentStage(stage.getCode());
    }
}

