/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.task.monitor;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.DateUtils;
import com.alibaba.ageiport.common.utils.TaskIdUtil;
import com.alibaba.ageiport.processor.core.spi.task.stage.Stage;
import java.text.DateFormat;
import java.util.Date;
import java.util.EventObject;

public class TaskStageEvent
extends EventObject {
    public static final Logger log = LoggerFactory.getLogger(TaskStageEvent.class);
    private static final long serialVersionUID = 5839929868828876453L;
    private String mainTaskId;
    private String subTaskId;
    private String stage;
    private String name;
    private String date;
    private Long cost;
    private Integer subCount;

    public boolean isMainTaskEvent() {
        return this.subTaskId == null;
    }

    public boolean isSubTaskEvent() {
        return !this.isMainTaskEvent();
    }

    public TaskStageEvent() {
        super("");
    }

    public TaskStageEvent(String id, String mainTaskId, String subTaskId, String stageCode, String stageName, Long cost, Integer subCount) {
        super(id);
        this.mainTaskId = mainTaskId;
        this.subTaskId = subTaskId;
        this.stage = stageCode;
        this.name = stageName;
        this.date = DateUtils.format((Date)new Date(), (DateFormat)DateUtils.NORM_DATETIME_FORMAT);
        this.cost = cost;
        this.subCount = subCount;
        if (subTaskId == null) {
            log.info("main:{}, stage:{}, cost:{}ms", new Object[]{mainTaskId, stageName, cost == null ? "-" : cost});
        } else {
            log.info("main:{}, sub:{}, stage:{}, cost:{}ms", new Object[]{mainTaskId, subTaskId, stageName, cost == null ? "-" : cost});
        }
    }

    public static TaskStageEvent mainTaskEvent(String mainTaskId, Stage stage) {
        TaskStageEvent event = new TaskStageEvent(mainTaskId, mainTaskId, null, stage.getCode(), stage.getName(), null, null);
        return event;
    }

    public static TaskStageEvent mainTaskEvent(String mainTaskId, Stage stage, Long cost) {
        TaskStageEvent event = new TaskStageEvent(mainTaskId, mainTaskId, null, stage.getCode(), stage.getName(), cost, null);
        return event;
    }

    public static TaskStageEvent mainTaskEvent(String mainTaskId, Stage stage, Long cost, Integer subCount) {
        TaskStageEvent event = new TaskStageEvent(mainTaskId, mainTaskId, null, stage.getCode(), stage.getName(), cost, subCount);
        return event;
    }

    public static TaskStageEvent subTaskEvent(String subTaskId, Stage stage) {
        String mainTaskId = TaskIdUtil.getMainTaskId((String)subTaskId);
        TaskStageEvent event = new TaskStageEvent(subTaskId, mainTaskId, subTaskId, stage.getCode(), stage.getName(), null, null);
        return event;
    }

    public static TaskStageEvent subTaskEvent(String subTaskId, Stage stage, Long cost) {
        String mainTaskId = TaskIdUtil.getMainTaskId((String)subTaskId);
        TaskStageEvent event = new TaskStageEvent(subTaskId, mainTaskId, subTaskId, stage.getCode(), stage.getName(), cost, null);
        return event;
    }

    public String getMainTaskId() {
        return this.mainTaskId;
    }

    public String getSubTaskId() {
        return this.subTaskId;
    }

    public String getStage() {
        return this.stage;
    }

    public String getName() {
        return this.name;
    }

    public String getDate() {
        return this.date;
    }

    public Long getCost() {
        return this.cost;
    }

    public Integer getSubCount() {
        return this.subCount;
    }

    public void setMainTaskId(String mainTaskId) {
        this.mainTaskId = mainTaskId;
    }

    public void setSubTaskId(String subTaskId) {
        this.subTaskId = subTaskId;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public void setSubCount(Integer subCount) {
        this.subCount = subCount;
    }
}

