/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.spi.task.stage;

import com.alibaba.ageiport.processor.core.spi.task.stage.Stage;
import com.alibaba.ageiport.processor.core.spi.task.stage.StageProvider;
import java.util.EventObject;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StageImpl
implements Stage {
    private String group;
    private Integer order;
    private String code;
    private String name;
    private Double minPercent;
    private Double maxPercent;
    private String description;
    private Class<? extends EventObject> triggerEvent;
    private StageProvider stageProvider;
    private boolean isFinal;
    private boolean isFinished;
    private boolean isError;

    public StageImpl() {
    }

    public StageImpl(String group, Integer order, String code, String name, Double minPercent, Double maxPercent, String description) {
        this.group = group;
        this.order = order;
        this.code = code;
        this.name = name;
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
        this.description = description;
    }

    public StageImpl(String group, Integer order, String code, String name, Double minPercent, Double maxPercent, String description, boolean isFinal, boolean isFinished, boolean isError) {
        this.group = group;
        this.order = order;
        this.code = code;
        this.name = name;
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
        this.description = description;
        this.isFinal = isFinal;
        this.isFinished = isFinished;
        this.isError = isError;
    }

    public StageImpl(String group, Integer order, String code, String name, Double minPercent, Double maxPercent, String description, Class<? extends EventObject> triggerEvent) {
        this.group = group;
        this.order = order;
        this.code = code;
        this.name = name;
        this.minPercent = minPercent;
        this.maxPercent = maxPercent;
        this.description = description;
        this.triggerEvent = triggerEvent;
    }

    @Override
    public Stage next() {
        if (this.isFinal) {
            return null;
        }
        List<Stage> stages = this.stageProvider.getStages();
        int current = -1;
        for (int i = 0; i < stages.size(); ++i) {
            Stage stage = stages.get(i);
            if (!stage.getCode().equals(this.code)) continue;
            current = i;
        }
        if (current < 0 || current >= stages.size() - 1) {
            return null;
        }
        return stages.get(current + 1);
    }

    @Override
    public Stage pre() {
        List<Stage> stages = this.stageProvider.getStages();
        int current = -1;
        for (int i = 0; i < stages.size(); ++i) {
            Stage stage = stages.get(i);
            if (!stage.getCode().equals(this.code)) continue;
            current = i;
        }
        if (current <= 0 || current >= stages.size()) {
            return null;
        }
        return stages.get(current - 1);
    }

    @Override
    public boolean isAfterThan(String code) {
        Stage stage = this.getStageProvider().getStage(code);
        return this.getOrder() > stage.getOrder();
    }

    @Override
    public boolean isBeforeThan(String code) {
        Stage stage = this.getStageProvider().getStage(code);
        return this.getOrder() < stage.getOrder();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public int compareTo(@NotNull Stage o) {
        return this.getOrder().compareTo(o.getOrder());
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Double getMinPercent() {
        return this.minPercent;
    }

    @Override
    public Double getMaxPercent() {
        return this.maxPercent;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<? extends EventObject> getTriggerEvent() {
        return this.triggerEvent;
    }

    @Override
    public StageProvider getStageProvider() {
        return this.stageProvider;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMinPercent(Double minPercent) {
        this.minPercent = minPercent;
    }

    public void setMaxPercent(Double maxPercent) {
        this.maxPercent = maxPercent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTriggerEvent(Class<? extends EventObject> triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    public void setStageProvider(StageProvider stageProvider) {
        this.stageProvider = stageProvider;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setFinished(boolean isFinished) {
        this.isFinished = isFinished;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }
}

