/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.event;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.eventbus.local.async.Subscribe;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.processor.core.spi.dispatcher.Dispatcher;
import com.alibaba.ageiport.processor.core.spi.dispatcher.DispatcherManager;
import com.alibaba.ageiport.processor.core.spi.dispatcher.RootDispatcherContext;
import com.alibaba.ageiport.processor.core.spi.eventbus.EventBus;
import com.alibaba.ageiport.processor.core.spi.listener.ManageableListener;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskStageEvent;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import com.alibaba.ageiport.processor.core.spi.task.stage.MainTaskStageProvider;
import com.alibaba.ageiport.processor.core.task.event.WaitDispatchMainTaskPrepareEvent;

public class WaitDispatchMainTaskPrepareEventListener
implements ManageableListener<WaitDispatchMainTaskPrepareEvent> {
    public static final Logger LOGGER = LoggerFactory.getLogger(WaitDispatchMainTaskPrepareEventListener.class);
    private AgeiPort ageiPort;
    private EventBus eventBus;

    @Override
    public void startListen(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        this.eventBus = ageiPort.getEventBusManager().getEventBus("STANDALONE");
        this.eventBus.register(this);
    }

    @Override
    @Subscribe
    public void handle(WaitDispatchMainTaskPrepareEvent event) {
        try {
            String mainTaskId = event.getMainTaskId();
            TaskServerClient client = this.ageiPort.getTaskServerClient();
            MainTask mainTask = client.getMainTask(mainTaskId);
            TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
            MainTaskStageProvider stageProvider = spiSelector.selectExtension(mainTask.getExecuteType(), mainTask.getType(), mainTask.getCode(), MainTaskStageProvider.class);
            EventBus bus = this.ageiPort.getEventBusManager().getEventBus(mainTask.getExecuteType());
            TaskStageEvent dispatchStartEvent = TaskStageEvent.mainTaskEvent(mainTaskId, stageProvider.mainTaskDispatchStart());
            bus.post(dispatchStartEvent);
            long startTime = System.currentTimeMillis();
            DispatcherManager dispatcherManager = this.ageiPort.getDispatcherManager();
            Dispatcher dispatcher = dispatcherManager.getDispatcher(mainTask.getExecuteType());
            RootDispatcherContext dispatcherContext = new RootDispatcherContext();
            dispatcherContext.setMainTaskId(mainTaskId);
            dispatcher.dispatchMainTaskPrepare(dispatcherContext);
            long costTime = System.currentTimeMillis() - startTime;
            TaskStageEvent dispatchEndEvent = TaskStageEvent.mainTaskEvent(mainTaskId, stageProvider.mainTaskDispatchEnd(), costTime);
            bus.post(dispatchEndEvent);
        }
        catch (Throwable e) {
            LOGGER.error("Handle WaitDispatchMainTaskPrepareEvent failed, ", e);
        }
    }
}

