/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.exporter;

import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.Processor;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizData;
import com.alibaba.ageiport.processor.core.model.api.BizDataGroup;
import com.alibaba.ageiport.processor.core.model.api.BizDataItem;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizExportPage;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDataGroupImpl;
import com.alibaba.ageiport.processor.core.spi.Adapter;
import com.alibaba.ageiport.processor.core.spi.convertor.Model;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.task.exporter.adapter.StandardExportProcessorAdapter;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface ExportProcessor<QUERY, DATA, VIEW>
extends Processor {
    @Override
    default public String resolver() {
        return "ExportSpecificationResolver";
    }

    default public Adapter getConcreteAdapter() {
        String name = StandardExportProcessorAdapter.class.getSimpleName();
        return (Adapter)ExtensionLoader.getExtensionLoader(Adapter.class).getExtension(name);
    }

    default public BizExportTaskRuntimeConfig taskRuntimeConfig(BizUser user, QUERY query) throws BizException {
        return null;
    }

    default public QUERY resetQuery(BizUser bizUser, QUERY query) throws BizException {
        return null;
    }

    public Integer totalCount(BizUser var1, QUERY var2) throws BizException;

    default public BizColumnHeaders getHeaders(BizUser user, QUERY query) throws BizException {
        return null;
    }

    default public BizDynamicColumnHeaders getDynamicHeaders(BizUser user, QUERY query) throws BizException {
        return null;
    }

    public List<DATA> queryData(BizUser var1, QUERY var2, BizExportPage var3) throws BizException;

    public List<VIEW> convert(BizUser var1, QUERY var2, List<DATA> var3) throws BizException;

    default public BizDataGroup<VIEW> group(BizUser user, QUERY query, List<VIEW> views) {
        BizDataGroupImpl group = new BizDataGroupImpl();
        BizDataGroupImpl.Data data = new BizDataGroupImpl.Data();
        ArrayList dataList = new ArrayList();
        dataList.add(data);
        group.setData(dataList);
        ArrayList items = new ArrayList();
        data.setItems(items);
        for (VIEW view : views) {
            BizDataGroupImpl.Item<VIEW> item = new BizDataGroupImpl.Item<VIEW>();
            item.setData(view);
            items.add(item);
        }
        return group;
    }

    default public DataGroup getDataGroup(BizUser user, QUERY query, BizDataGroup<VIEW> bizDataGroup) {
        DataGroup dataGroup = new DataGroup();
        ArrayList<DataGroup.Data> dataList = new ArrayList<DataGroup.Data>();
        dataGroup.setData(dataList);
        List<BizData<VIEW>> bizData = bizDataGroup.getBizData();
        for (BizData<VIEW> bizDatum : bizData) {
            DataGroup.Data data = new DataGroup.Data();
            dataList.add(data);
            data.setCode(bizDatum.getCode());
            data.setMeta(bizDatum.getMeta());
            ArrayList<DataGroup.Item> items = new ArrayList<DataGroup.Item>();
            data.setItems(items);
            List<BizDataItem<VIEW>> bizDataItems = bizDatum.getItems();
            for (BizDataItem<VIEW> bizDataItem : bizDataItems) {
                Map<String, Object> map = Model.toMap(bizDataItem.getData());
                DataGroup.Item item = new DataGroup.Item();
                item.setValues(map);
                items.add(item);
            }
        }
        return dataGroup;
    }
}

