/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.importer;

import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.common.utils.TypeUtils;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.Processor;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizData;
import com.alibaba.ageiport.processor.core.model.api.BizDataGroup;
import com.alibaba.ageiport.processor.core.model.api.BizDataItem;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDataGroupImpl;
import com.alibaba.ageiport.processor.core.spi.Adapter;
import com.alibaba.ageiport.processor.core.spi.convertor.Model;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.task.importer.adapter.StandardImportProcessorAdapter;
import com.alibaba.ageiport.processor.core.task.importer.api.BizImportTaskRuntimeConfig;
import com.alibaba.ageiport.processor.core.task.importer.model.BizImportResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ImportProcessor<QUERY, DATA, VIEW>
extends Processor {
    @Override
    default public String resolver() {
        return "ImportSpecificationResolver";
    }

    default public Adapter getConcreteAdapter() {
        String name = StandardImportProcessorAdapter.class.getSimpleName();
        return (Adapter)ExtensionLoader.getExtensionLoader(Adapter.class).getExtension(name);
    }

    default public QUERY resetQuery(BizUser bizUser, QUERY query) throws BizException {
        return null;
    }

    default public BizImportTaskRuntimeConfig taskRuntimeConfig(BizUser user, QUERY query) throws BizException {
        return null;
    }

    default public BizColumnHeaders getHeaders(BizUser user, QUERY query) throws BizException {
        return null;
    }

    default public BizDynamicColumnHeaders getDynamicHeaders(BizUser user, QUERY query) throws BizException {
        return null;
    }

    default public DataGroup checkHeaders(BizUser user, QUERY query, DataGroup group) throws BizException {
        return group;
    }

    default public BizDataGroup<VIEW> getBizDataGroup(BizUser user, QUERY query, DataGroup group) throws BizException {
        List genericParamType = TypeUtils.getGenericParamType(this.getClass(), ImportProcessor.class);
        Class viewClass = genericParamType.size() > 2 ? (Class)genericParamType.get(2) : null;
        BizDataGroupImpl bizDataGroup = new BizDataGroupImpl();
        ArrayList bizDataList = new ArrayList();
        bizDataGroup.setData(bizDataList);
        for (DataGroup.Data data : group.getData()) {
            ArrayList items = new ArrayList();
            BizDataGroupImpl.Data bizData = new BizDataGroupImpl.Data();
            bizDataList.add(bizData);
            bizData.setCode(data.getCode());
            bizData.setMeta(data.getMeta());
            bizData.setItems(items);
            for (DataGroup.Item item : data.getItems()) {
                Object view = JsonUtil.toObject((String)"{}", (Class)viewClass);
                HashMap<String, Object> values = new HashMap<String, Object>(item.getValues());
                values.putAll(data.getMeta());
                Model.toModel(values, view);
                BizDataGroupImpl.Item<Object> dataItem = new BizDataGroupImpl.Item<Object>();
                dataItem.setCode(item.getCode());
                dataItem.setData(view);
                items.add(dataItem);
            }
        }
        return bizDataGroup;
    }

    default public List<VIEW> flat(BizUser user, QUERY query, BizDataGroup<VIEW> views) throws BizException {
        ArrayList<VIEW> result = new ArrayList<VIEW>();
        List<BizData<VIEW>> bizData = views.getBizData();
        for (BizData<VIEW> bizDatum : bizData) {
            List<BizDataItem<VIEW>> items = bizDatum.getItems();
            for (BizDataItem<VIEW> item : items) {
                VIEW data = item.getData();
                result.add(data);
            }
        }
        return result;
    }

    public BizImportResult<VIEW, DATA> convertAndCheck(BizUser var1, QUERY var2, List<VIEW> var3);

    public BizImportResult<VIEW, DATA> write(BizUser var1, QUERY var2, List<DATA> var3);

    default public BizDataGroup<VIEW> group(BizUser user, QUERY query, List<VIEW> views) {
        BizDataGroupImpl group = new BizDataGroupImpl();
        BizDataGroupImpl.Data data = new BizDataGroupImpl.Data();
        ArrayList dataList = new ArrayList();
        dataList.add(data);
        group.setData(dataList);
        ArrayList items = new ArrayList();
        data.setItems(items);
        for (VIEW view : views) {
            BizDataGroupImpl.Item<VIEW> item = new BizDataGroupImpl.Item<VIEW>();
            item.setData(view);
            items.add(item);
        }
        return group;
    }

    default public DataGroup getDataGroup(BizUser user, QUERY query, BizDataGroup<VIEW> bizDataGroup) {
        DataGroup dataGroup = new DataGroup();
        ArrayList<DataGroup.Data> dataList = new ArrayList<DataGroup.Data>();
        dataGroup.setData(dataList);
        List<BizData<VIEW>> bizData = bizDataGroup.getBizData();
        for (BizData<VIEW> bizDatum : bizData) {
            DataGroup.Data data = new DataGroup.Data();
            dataList.add(data);
            data.setCode(bizDatum.getCode());
            data.setMeta(bizDatum.getMeta());
            ArrayList<DataGroup.Item> items = new ArrayList<DataGroup.Item>();
            data.setItems(items);
            List<BizDataItem<VIEW>> bizDataItems = bizDatum.getItems();
            for (BizDataItem<VIEW> bizDataItem : bizDataItems) {
                Map<String, Object> map = Model.toMap(bizDataItem.getData());
                DataGroup.Item item = new DataGroup.Item();
                item.setValues(map);
                items.add(item);
            }
        }
        return dataGroup;
    }
}

