/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.monitor;

import com.alibaba.ageiport.common.function.VoidCallback;
import com.alibaba.ageiport.common.lang.DelayedElement;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.DelayQueue;

public class ClearTask {
    private final Logger LOGGER = LoggerFactory.getLogger(ClearTask.class);
    private final DelayQueue<DelayedElement<String>> DELAYED_CLEAN_QUEUE = new DelayQueue();
    private final Map<String, VoidCallback> CALLBACK_MAP = new HashMap<String, VoidCallback>(32);

    public ClearTask(String name) {
        Thread cleanThread = new Thread(() -> {
            while (true) {
                DelayedElement clearTask = null;
                try {
                    clearTask = (DelayedElement)this.DELAYED_CLEAN_QUEUE.take();
                    this.clear((String)clearTask.getData());
                    continue;
                }
                catch (Throwable e) {
                    this.LOGGER.error("ClearTask#failed, task:{}", new Object[]{clearTask, e});
                    continue;
                }
                break;
            }
        });
        cleanThread.setName(name);
        cleanThread.setDaemon(true);
        cleanThread.start();
    }

    public synchronized void addClearTask(String key, long delay, VoidCallback callback) {
        boolean exist = this.CALLBACK_MAP.containsKey(key);
        String clearTaskKey = exist ? key + System.nanoTime() : key;
        DelayedElement clearTask = new DelayedElement(delay, (Object)clearTaskKey);
        this.DELAYED_CLEAN_QUEUE.add((DelayedElement<String>)clearTask);
        this.CALLBACK_MAP.put(clearTaskKey, callback);
    }

    private void clear(String taskId) {
        VoidCallback callback = this.CALLBACK_MAP.remove(taskId);
        Optional.ofNullable(callback).ifPresent(VoidCallback::call);
    }
}

