/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.monitor;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.spi.task.monitor.MainTaskProgress;
import com.alibaba.ageiport.processor.core.spi.task.monitor.SubTaskProgress;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressLog;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressMonitor;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskProgressService;
import com.alibaba.ageiport.processor.core.spi.task.monitor.TaskStageEvent;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import com.alibaba.ageiport.processor.core.spi.task.stage.MainTaskStageProvider;
import com.alibaba.ageiport.processor.core.spi.task.stage.Stage;
import com.alibaba.ageiport.processor.core.spi.task.stage.SubTaskStageProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TaskProgressServiceImpl
implements TaskProgressService {
    public static Logger log = LoggerFactory.getLogger(TaskProgressServiceImpl.class);
    private Map<String, MainTaskProgress> mainTaskProgressMap = new ConcurrentHashMap<String, MainTaskProgress>();
    private AgeiPort ageiPort;
    private TaskProgressMonitor monitor;

    public TaskProgressServiceImpl(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
        this.monitor = ageiPort.getTaskProgressMonitor();
    }

    @Override
    public void updateTaskProgress(TaskStageEvent event) {
        try {
            if (event.isMainTaskEvent()) {
                log.info("update progress, main:{}, stage:{}", new Object[]{event.getMainTaskId(), event.getStage()});
                this.updateMainTaskProgress(event);
            } else {
                log.info("update progress, main:{}, sub:{}, stage:{}", new Object[]{event.getMainTaskId(), event.getSubTaskId(), event.getStage()});
                this.updateSubTaskProgress(event);
            }
        }
        catch (Throwable e) {
            log.error("update progress failed, main:{}, sub:{}, stage:{}", new Object[]{event.getMainTaskId(), event.getSubTaskId(), event.getName(), e});
        }
    }

    public void updateMainTaskProgress(TaskStageEvent event) {
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(event.getMainTaskId());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        MainTaskStageProvider mainTaskStageProvider = spiSelector.selectExtension(mainTask.getExecuteType(), mainTask.getType(), mainTask.getCode(), MainTaskStageProvider.class);
        Stage newStage = mainTaskStageProvider.getStage(event.getStage());
        Stage oldStage = null;
        TaskProgressLog log = TaskProgressServiceImpl.createLog(event, newStage);
        MainTaskProgress taskProgress = this.getTaskProgress(event.getMainTaskId());
        if (taskProgress == null) {
            taskProgress = this.createMainTaskProgress(event.getMainTaskId(), newStage, event);
            this.mainTaskProgressMap.put(taskProgress.getMainTaskId(), taskProgress);
        } else {
            oldStage = mainTaskStageProvider.getStage(taskProgress.getStageCode());
            if (!newStage.isAfterThan(oldStage.getCode())) {
                return;
            }
            taskProgress.setStageCode(newStage.getCode());
            taskProgress.setStageName(newStage.getName());
            taskProgress.setIsFinished(newStage.isFinished());
            taskProgress.setIsError(newStage.isError());
            taskProgress.setIsFinished(newStage.isFinished());
            taskProgress.setPercent(newStage.getMaxPercent());
            if (event.getSubCount() != null) {
                taskProgress.setTotalSubTaskCount(event.getSubCount());
                if (taskProgress.getErrorSubTaskCount() == null) {
                    taskProgress.setErrorSubTaskCount(0);
                }
                if (taskProgress.getFinishedSubTaskCount() == null) {
                    taskProgress.setFinishedSubTaskCount(0);
                }
            }
        }
        taskProgress.addLog(log);
        this.monitor.onMainTaskChanged(taskProgress, oldStage, newStage);
    }

    public void updateSubTaskProgress(TaskStageEvent event) {
        TaskProgressLog subLog;
        SubTaskProgress subTaskProgress;
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(event.getMainTaskId());
        TaskSpiSelector spiSelector = this.ageiPort.getTaskSpiSelector();
        SubTaskStageProvider subTaskStageProvider = spiSelector.selectExtension(mainTask.getExecuteType(), mainTask.getType(), mainTask.getCode(), SubTaskStageProvider.class);
        MainTaskStageProvider mainTaskStageProvider = spiSelector.selectExtension(mainTask.getExecuteType(), mainTask.getType(), mainTask.getCode(), MainTaskStageProvider.class);
        Stage newStage = subTaskStageProvider.getStage(event.getStage());
        MainTaskProgress mainTaskProgress = this.getTaskProgress(event.getMainTaskId());
        if (mainTaskProgress == null) {
            mainTaskProgress = this.createMainTaskProgress(event.getMainTaskId(), mainTaskStageProvider.mainTaskCreated(), null);
            TaskProgressLog mainLog = TaskProgressServiceImpl.createLog(null, mainTaskStageProvider.mainTaskCreated());
            mainTaskProgress.addLog(mainLog);
            this.mainTaskProgressMap.put(mainTaskProgress.getMainTaskId(), mainTaskProgress);
            subTaskProgress = this.createSubTaskProgress(event.getSubTaskId(), newStage);
            subLog = TaskProgressServiceImpl.createLog(event, newStage);
            subTaskProgress.addLog(subLog);
            mainTaskProgress.addSubTaskProgress(subTaskProgress);
        }
        Stage mainStage = mainTaskStageProvider.getStage(mainTaskProgress.getStageCode());
        subTaskProgress = mainTaskProgress.getSubTaskProgress(event.getSubTaskId());
        if (subTaskProgress == null) {
            subTaskProgress = this.createSubTaskProgress(event.getSubTaskId(), newStage);
            subLog = TaskProgressServiceImpl.createLog(event, newStage);
            subTaskProgress.addLog(subLog);
            mainTaskProgress.addSubTaskProgress(subTaskProgress);
        }
        Stage oldStage = subTaskStageProvider.getStage(subTaskProgress.getStageCode());
        if (newStage.getOrder() >= oldStage.getOrder()) {
            TaskProgressLog subLog2 = TaskProgressServiceImpl.createLog(event, newStage);
            subTaskProgress.addLog(subLog2);
            subTaskProgress.setStageCode(newStage.getCode());
            subTaskProgress.setStageName(newStage.getName());
            subTaskProgress.setIsFinished(newStage.isFinished());
            subTaskProgress.setIsError(newStage.isError());
            subTaskProgress.setPercent(newStage.getMaxPercent());
            this.monitor.onSubTaskChanged(mainTaskProgress, subTaskProgress, oldStage, newStage, mainStage);
        } else {
            TaskProgressLog subLog3 = TaskProgressServiceImpl.createLog(event, newStage);
            subTaskProgress.addLog(subLog3);
        }
    }

    private SubTaskProgress createSubTaskProgress(String subTaskId, Stage newStage) {
        SubTaskProgress subTaskProgress = new SubTaskProgress();
        subTaskProgress.setSubTaskId(subTaskId);
        subTaskProgress.setLogs(new ArrayList<TaskProgressLog>());
        subTaskProgress.setStageCode(newStage.getCode());
        subTaskProgress.setStageName(newStage.getName());
        subTaskProgress.setIsError(newStage.isError());
        subTaskProgress.setIsFinished(newStage.isFinished());
        subTaskProgress.setPercent(newStage.getMaxPercent());
        return subTaskProgress;
    }

    private MainTaskProgress createMainTaskProgress(String mainTaskId, Stage newStage, TaskStageEvent event) {
        MainTaskProgress mainTaskProgress = new MainTaskProgress();
        mainTaskProgress.setMainTaskId(mainTaskId);
        mainTaskProgress.setStageCode(newStage.getCode());
        mainTaskProgress.setStageName(newStage.getName());
        mainTaskProgress.setIsError(newStage.isError());
        mainTaskProgress.setIsFinished(newStage.isFinished());
        mainTaskProgress.setPercent(newStage.getMaxPercent());
        if (event != null) {
            mainTaskProgress.setTotalSubTaskCount(event.getSubCount());
        }
        if (mainTaskProgress.getErrorSubTaskCount() == null) {
            mainTaskProgress.setErrorSubTaskCount(0);
        }
        if (mainTaskProgress.getFinishedSubTaskCount() == null) {
            mainTaskProgress.setFinishedSubTaskCount(0);
        }
        mainTaskProgress.setLogs(new ArrayList<TaskProgressLog>());
        mainTaskProgress.setSubTaskProgressMap(new ConcurrentHashMap<String, SubTaskProgress>());
        return mainTaskProgress;
    }

    private static TaskProgressLog createLog(TaskStageEvent event, Stage newStage) {
        TaskProgressLog taskProgressLog = new TaskProgressLog();
        taskProgressLog.setStage(newStage.getCode());
        taskProgressLog.setName(newStage.getName());
        taskProgressLog.setOrder(newStage.getOrder());
        if (event != null) {
            taskProgressLog.setCost(event.getCost());
            taskProgressLog.setDate(event.getDate());
        }
        return taskProgressLog;
    }

    @Override
    public MainTaskProgress getTaskProgress(String mainTaskId) {
        return this.mainTaskProgressMap.get(mainTaskId);
    }

    @Override
    public MainTaskProgress removeTaskProgress(String mainTaskId) {
        return this.mainTaskProgressMap.remove(mainTaskId);
    }
}

