/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.registry;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.model.core.impl.TaskSpecification;
import com.alibaba.ageiport.processor.core.spi.client.CreateSpecificationRequest;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationProvider;
import com.alibaba.ageiport.processor.core.spi.task.specification.TaskSpecificationRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SpecificationRegistryImpl
implements TaskSpecificationRegistry {
    public static final Logger logger = LoggerFactory.getLogger(SpecificationRegistryImpl.class);
    private Map<String, TaskSpec> taskSpecMap = new ConcurrentHashMap<String, TaskSpec>();

    public SpecificationRegistryImpl(AgeiPort ageiPort) {
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(TaskSpecificationProvider.class);
        Set extensionInstances = extensionLoader.getSupportedExtensionInstances();
        TaskServerClient taskServerClient = ageiPort.getTaskServerClient();
        for (TaskSpecificationProvider provider : extensionInstances) {
            List<TaskSpec> taskSpecs = provider.provide(ageiPort);
            for (TaskSpec taskSpec : taskSpecs) {
                this.taskSpecMap.put(taskSpec.getTaskCode(), taskSpec);
                TaskSpecification specification = taskServerClient.getTaskSpecification(taskSpec.getTaskCode());
                if (specification != null) {
                    logger.info("TaskSpecification already exist, app:{},code:{}", new Object[]{ageiPort.getOptions().getApp(), specification.getTaskCode()});
                    continue;
                }
                CreateSpecificationRequest request = new CreateSpecificationRequest();
                request.setTaskCode(taskSpec.getTaskCode());
                request.setTaskName(taskSpec.getTaskName());
                request.setTaskDesc(taskSpec.getTaskDesc());
                request.setTaskType(taskSpec.getTaskType());
                request.setTaskExecuteType(taskSpec.getExecuteType());
                request.setTaskHandler(taskSpec.getProcessor().getClass().getName());
                try {
                    String result = taskServerClient.createTaskSpecification(request);
                    logger.info("TaskSpecification already registry, app:{},code:{}, id:{}", new Object[]{ageiPort.getOptions().getApp(), taskSpec.getTaskCode(), result});
                }
                catch (Throwable e) {
                    logger.error("createTaskSpecification failed, request:{}", new Object[]{request, e});
                    throw new IllegalStateException("createTaskSpecification failed, code:" + taskSpec.getTaskCode());
                }
            }
        }
    }

    @Override
    public void add(TaskSpec taskSpec) {
        this.taskSpecMap.put(taskSpec.getTaskCode(), taskSpec);
    }

    @Override
    public TaskSpec get(String taskCode) {
        if (taskCode == null) {
            throw new IllegalArgumentException("taskCode is null");
        }
        return this.taskSpecMap.get(taskCode);
    }
}

