/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.task.selector;

import com.alibaba.ageiport.common.utils.StringUtils;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.spi.task.selector.TaskSpiSelector;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TaskSpiSelectorImpl
implements TaskSpiSelector {
    private Map<String, String> mappings;

    public TaskSpiSelectorImpl(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public <T> String selectExtensionName(String taskExecuteType, String taskType, String taskCode, Class<T> spi) {
        String extensionName;
        ExtensionLoader extensionLoader = ExtensionLoader.getExtensionLoader(spi);
        if (extensionLoader.hasExtension(extensionName = TaskSpiSelectorImpl.getKey(null, null, taskCode, spi))) {
            return extensionName;
        }
        extensionName = TaskSpiSelectorImpl.getKey(taskExecuteType, taskType, null, spi);
        if (extensionLoader.hasExtension(extensionName)) {
            return extensionName;
        }
        extensionName = TaskSpiSelectorImpl.getKey(taskExecuteType, null, null, spi);
        if (extensionLoader.hasExtension(extensionName)) {
            return extensionName;
        }
        extensionName = TaskSpiSelectorImpl.getKey(null, taskType, null, spi);
        if (extensionLoader.hasExtension(extensionName)) {
            return extensionName;
        }
        extensionName = TaskSpiSelectorImpl.getKey(null, null, null, spi);
        if (extensionLoader.hasExtension(extensionName)) {
            return extensionName;
        }
        String template = "no support extension for spi:{},taskExecuteType:{},taskType:{},taskCode:{}";
        String errorMsg = StringUtils.format((String)template, (Object[])new Object[]{spi.getName(), taskExecuteType, taskType, taskCode});
        throw new IllegalArgumentException(errorMsg);
    }

    @NotNull
    private static <T> String getKey(String taskExecuteType, String taskType, String taskCode, Class<T> spi) {
        String prefix = "";
        if (StringUtils.isNotBlank((CharSequence)taskExecuteType)) {
            prefix = prefix + taskExecuteType.substring(0, 1).toUpperCase() + taskExecuteType.substring(1).toLowerCase();
        }
        if (StringUtils.isNotBlank((CharSequence)taskType)) {
            prefix = prefix + taskType.substring(0, 1).toUpperCase() + taskType.substring(1).toLowerCase();
        }
        if (StringUtils.isNotBlank((CharSequence)taskCode)) {
            prefix = prefix + taskCode;
        }
        if (prefix.length() == 0) {
            return spi.getSimpleName() + "Impl";
        }
        return prefix + spi.getSimpleName();
    }

    @Override
    public <T> T selectExtension(String taskExecuteType, String taskType, String taskCode, Class<T> spi) {
        String selectExtensionName = this.selectExtensionName(taskExecuteType, taskType, taskCode, spi);
        return (T)ExtensionLoader.getExtensionLoader(spi).getExtension(selectExtensionName);
    }

    @Override
    public <T> void registryExtension(String taskExecuteType, String taskType, String taskCode, Class<T> spi, String extensionName) {
        String key = TaskSpiSelectorImpl.getKey(taskExecuteType, taskType, taskCode, spi);
        this.mappings.put(taskExecuteType, key);
    }
}

