/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.redshift.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLTop;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.dialect.redshift.parser.RedshiftExprParser;
import com.alibaba.druid.sql.dialect.redshift.stmt.RedshiftSelectQueryBlock;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLSelectListCache;
import com.alibaba.druid.sql.parser.Token;

public class RedshiftSelectParser
extends PGSelectParser {
    public RedshiftSelectParser(SQLExprParser exprParser, SQLSelectListCache selectListCache) {
        super(exprParser, selectListCache);
        this.dbType = DbType.redshift;
    }

    @Override
    protected RedshiftExprParser createExprParser() {
        return new RedshiftExprParser(this.lexer);
    }

    @Override
    public SQLSelectQuery query(SQLObject parent, boolean acceptUnion) {
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLSelectQuery select = this.query();
            this.accept(Token.RPAREN);
            return this.queryRest(select, acceptUnion);
        }
        RedshiftSelectQueryBlock queryBlock = new RedshiftSelectQueryBlock();
        if (this.lexer.token() == Token.SELECT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.TOP) {
                SQLTop top = this.createExprParser().parseTop();
                queryBlock.setTop(top);
            }
            if (this.lexer.token() == Token.DISTINCT) {
                queryBlock.setDistionOption(2);
                this.lexer.nextToken();
            } else if (this.lexer.token() == Token.ALL) {
                queryBlock.setDistionOption(1);
                this.lexer.nextToken();
            }
            this.parseSelectList(queryBlock);
        }
        this.parseInto(queryBlock);
        this.parseFrom(queryBlock);
        this.parseWhere(queryBlock);
        this.parseHierachical(queryBlock);
        this.parseGroupBy(queryBlock);
        this.qualify(queryBlock);
        this.parseSortBy(queryBlock);
        this.parseFetchClause(queryBlock);
        return this.queryRest(queryBlock, acceptUnion);
    }

    protected void parseInto(RedshiftSelectQueryBlock queryBlock) {
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            if (this.lexer.nextIfIdentifier("TEMP")) {
                queryBlock.setInsertTemp(true);
            }
            if (this.lexer.nextIfIdentifier("TEMPORARY")) {
                queryBlock.setInsertTemporary(true);
            }
            if (this.lexer.nextIf(Token.TABLE)) {
                queryBlock.setInsertTable(true);
            }
            SQLTableSource into = this.parseTableSource();
            queryBlock.setInto((SQLExprTableSource)into);
        }
    }
}

