/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters.date;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateNumberConverter
implements Converter<Date> {
    @Override
    public Class supportJavaTypeKey() {
        return Date.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.NUMBER;
    }

    @Override
    public Date convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (contentProperty == null || contentProperty.getDateTimeFormatProperty() == null) {
            return DateUtil.getJavaDate((double)cellData.getNumberValue().doubleValue(), (boolean)globalConfiguration.getUse1904windowing(), null);
        }
        return DateUtil.getJavaDate((double)cellData.getNumberValue().doubleValue(), (boolean)contentProperty.getDateTimeFormatProperty().getUse1904windowing(), null);
    }

    @Override
    public CellData convertToExcelData(Date value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (contentProperty == null || contentProperty.getDateTimeFormatProperty() == null) {
            return new CellData(BigDecimal.valueOf(DateUtil.getExcelDate((Date)value, (boolean)globalConfiguration.getUse1904windowing())));
        }
        return new CellData(BigDecimal.valueOf(DateUtil.getExcelDate((Date)value, (boolean)contentProperty.getDateTimeFormatProperty().getUse1904windowing())));
    }
}

