/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.metadata.BaseRowModel;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ClassUtils {
    private static final Map<Class, SoftReference<FieldCache>> FIELD_CACHE = new ConcurrentHashMap<Class, SoftReference<FieldCache>>();

    public static void declaredFields(Class clazz, List<Field> defaultFieldList, Map<Integer, Field> customFiledMap, Map<String, Field> ignoreMap, Boolean convertAllFiled) {
        FieldCache fieldCache = ClassUtils.getFieldCache(clazz, convertAllFiled);
        if (fieldCache != null) {
            defaultFieldList.addAll(fieldCache.getDefaultFieldList());
            customFiledMap.putAll(fieldCache.getCustomFiledMap());
            ignoreMap.putAll(fieldCache.getIgnoreMap());
        }
    }

    public static void declaredFields(Class clazz, List<Field> fieldList, Boolean convertAllFiled) {
        FieldCache fieldCache = ClassUtils.getFieldCache(clazz, convertAllFiled);
        if (fieldCache != null) {
            fieldList.addAll(fieldCache.getAllFieldList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FieldCache getFieldCache(Class clazz, Boolean convertAllFiled) {
        if (clazz == null) {
            return null;
        }
        SoftReference<FieldCache> fieldCacheSoftReference = FIELD_CACHE.get(clazz);
        if (fieldCacheSoftReference != null && fieldCacheSoftReference.get() != null) {
            return fieldCacheSoftReference.get();
        }
        Class clazz2 = clazz;
        synchronized (clazz2) {
            fieldCacheSoftReference = FIELD_CACHE.get(clazz);
            if (fieldCacheSoftReference != null && fieldCacheSoftReference.get() != null) {
                return fieldCacheSoftReference.get();
            }
            ClassUtils.declaredFields(clazz, convertAllFiled);
        }
        return FIELD_CACHE.get(clazz).get();
    }

    private static void declaredFields(Class clazz, Boolean convertAllFiled) {
        ArrayList tempFieldList = new ArrayList();
        for (Class tempClass = clazz; tempClass != null && tempClass != BaseRowModel.class; tempClass = tempClass.getSuperclass()) {
            Collections.addAll(tempFieldList, tempClass.getDeclaredFields());
        }
        ArrayList<Field> defaultFieldList = new ArrayList<Field>();
        TreeMap<Integer, Field> customFiledMap = new TreeMap<Integer, Field>();
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        HashMap<String, Field> ignoreMap = new HashMap<String, Field>(16);
        ExcelIgnoreUnannotated excelIgnoreUnannotated = clazz.getAnnotation(ExcelIgnoreUnannotated.class);
        for (Field field : tempFieldList) {
            boolean isStaticFinalOrTransient;
            boolean noExcelProperty;
            ExcelIgnore excelIgnore = field.getAnnotation(ExcelIgnore.class);
            if (excelIgnore != null) {
                ignoreMap.put(field.getName(), field);
                continue;
            }
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            boolean bl = noExcelProperty = excelProperty == null && (convertAllFiled != null && convertAllFiled == false || excelIgnoreUnannotated != null);
            if (noExcelProperty) {
                ignoreMap.put(field.getName(), field);
                continue;
            }
            boolean bl2 = isStaticFinalOrTransient = Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
            if (excelProperty == null && isStaticFinalOrTransient) {
                ignoreMap.put(field.getName(), field);
                continue;
            }
            if (excelProperty == null || excelProperty.index() < 0) {
                defaultFieldList.add(field);
                allFieldList.add(field);
                continue;
            }
            if (customFiledMap.containsKey(excelProperty.index())) {
                throw new ExcelCommonException("The index of '" + ((Field)customFiledMap.get(excelProperty.index())).getName() + "' and '" + field.getName() + "' must be inconsistent");
            }
            customFiledMap.put(excelProperty.index(), field);
        }
        ArrayList<Field> allWriteFieldList = new ArrayList<Field>(customFiledMap.values());
        allWriteFieldList.addAll(allFieldList);
        FIELD_CACHE.put(clazz, new SoftReference<FieldCache>(new FieldCache(defaultFieldList, customFiledMap, allWriteFieldList, ignoreMap)));
    }

    private static class FieldCache {
        private List<Field> defaultFieldList;
        private Map<Integer, Field> customFiledMap;
        private List<Field> allFieldList;
        private Map<String, Field> ignoreMap;

        public FieldCache(List<Field> defaultFieldList, Map<Integer, Field> customFiledMap, List<Field> allFieldList, Map<String, Field> ignoreMap) {
            this.defaultFieldList = defaultFieldList;
            this.customFiledMap = customFiledMap;
            this.allFieldList = allFieldList;
            this.ignoreMap = ignoreMap;
        }

        public List<Field> getDefaultFieldList() {
            return this.defaultFieldList;
        }

        public Map<Integer, Field> getCustomFiledMap() {
            return this.customFiledMap;
        }

        public List<Field> getAllFieldList() {
            return this.allFieldList;
        }

        public Map<String, Field> getIgnoreMap() {
            return this.ignoreMap;
        }
    }
}

