/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayParser;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayRequestWrapper;
import com.alipay.api.AlipayResponse;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.BatchAlipayRequest;
import com.alipay.api.BatchAlipayResponse;
import com.alipay.api.Decryptor;
import com.alipay.api.Encryptor;
import com.alipay.api.FileItem;
import com.alipay.api.ResponseEncryptItem;
import com.alipay.api.SignChecker;
import com.alipay.api.SignItem;
import com.alipay.api.Signer;
import com.alipay.api.internal.parser.json.ObjectJsonParser;
import com.alipay.api.internal.parser.xml.ObjectXmlParser;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.AlipayUtils;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import com.alipay.api.internal.util.json.JSONWriter;
import java.io.IOException;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAlipayClient
implements AlipayClient {
    private String serverUrl;
    private String appId;
    private String prodCode;
    private String format = "json";
    private String signType = "RSA";
    private String encryptType = "AES";
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private String proxyHost;
    private int proxyPort;
    private static final String BATCH_API_DEFAULT_SPLIT = "#S#";

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        if (!StringUtils.isEmpty(format)) {
            this.format = format;
        }
        this.charset = charset;
        if (!StringUtils.isEmpty(signType)) {
            this.signType = signType;
        }
    }

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType, String proxyHost, int proxyPort) {
        this(serverUrl, appId, format, charset, signType);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType, String encryptType) {
        this(serverUrl, appId, format, charset, signType);
        if (!StringUtils.isEmpty(encryptType)) {
            this.encryptType = encryptType;
        }
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request) throws AlipayApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        return this.execute(request, accessToken, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken, String appAuthToken) throws AlipayApiException {
        AlipayParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, accessToken, appAuthToken);
    }

    @Override
    public BatchAlipayResponse execute(BatchAlipayRequest request) throws AlipayApiException {
        long beginTime = System.currentTimeMillis();
        Map<String, Object> rt = this.doPost(request);
        if (rt == null) {
            return null;
        }
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        AlipayParser<BatchAlipayResponse> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<BatchAlipayResponse>(request.getResponseClass()) : new ObjectJsonParser<BatchAlipayResponse>(request.getResponseClass());
        BatchAlipayResponse batchAlipayResponse = null;
        try {
            int i;
            ResponseEncryptItem responseItem = this.decryptResponse(request, rt, parser);
            batchAlipayResponse = parser.parse(responseItem.getRealContent());
            batchAlipayResponse.setBody(responseItem.getRealContent());
            this.checkResponseSign(request, parser, responseItem.getRespContent(), batchAlipayResponse.isSuccess());
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
            ArrayList parserList = new ArrayList();
            List<AlipayRequestWrapper> requestList = request.getRequestList();
            if ("xml".equals(this.format)) {
                for (i = 0; i < requestList.size(); ++i) {
                    parserList.add(new ObjectXmlParser(requestList.get(i).getAlipayRequest().getResponseClass()));
                }
            } else {
                for (i = 0; i < requestList.size(); ++i) {
                    parserList.add(new ObjectJsonParser(requestList.get(i).getAlipayRequest().getResponseClass()));
                }
            }
            if (!batchAlipayResponse.isSuccess()) {
                return batchAlipayResponse;
            }
            String[] responseArray = batchAlipayResponse.getResponseBody().split(BATCH_API_DEFAULT_SPLIT);
            for (int index = 0; index < responseArray.length; ++index) {
                Object alipayResponse = ((AlipayParser)parserList.get(index)).parse(responseArray[index]);
                ((AlipayResponse)alipayResponse).setBody(responseArray[index]);
                batchAlipayResponse.addResponse((AlipayResponse)alipayResponse);
            }
            AlipayLogger.logBizDebug((String)rt.get("rsp"));
            return batchAlipayResponse;
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw new AlipayApiException(e);
        }
    }

    private Map<String, Object> doPost(BatchAlipayRequest request) throws AlipayApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request);
        String url = this.getRequestUrl(requestHolder);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", url);
        return result;
    }

    private <T extends AlipayResponse> RequestParametersHolder getRequestHolderWithSign(BatchAlipayRequest request) throws AlipayApiException {
        List<AlipayRequestWrapper> requestList = request.getRequestList();
        if (requestList == null || requestList.isEmpty()) {
            throw new AlipayApiException("40", "client-error:api request list is empty");
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.signType);
        protocalMustParams.put("charset", this.charset);
        protocalMustParams.put("version", request.getApiVersion());
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-3.7.26.ALL");
        requestHolder.setProtocalOptParams(protocalOptParams);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap appParams = new AlipayHashMap();
        StringBuilder requestBody = new StringBuilder();
        for (int index = 0; index < requestList.size(); ++index) {
            AlipayRequestWrapper alipayRequestWrapper = requestList.get(index);
            AlipayRequest alipayRequest = alipayRequestWrapper.getAlipayRequest();
            Map<String, String> apiParams = alipayRequest.getTextParams();
            apiParams.put("method", alipayRequest.getApiMethodName());
            apiParams.put("app_auth_token", alipayRequestWrapper.getAppAuthToken());
            apiParams.put("auth_token", alipayRequestWrapper.getAccessToken());
            apiParams.put("prod_code", alipayRequest.getProdCode());
            apiParams.put("notify_url", alipayRequest.getNotifyUrl());
            apiParams.put("return_url", alipayRequest.getReturnUrl());
            apiParams.put("terminal_info", alipayRequest.getTerminalInfo());
            apiParams.put("terminal_type", alipayRequest.getTerminalType());
            apiParams.put("batch_request_id", String.valueOf(index));
            try {
                if (alipayRequest.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("biz_content")) && alipayRequest.getBizModel() != null) {
                    apiParams.put("biz_content", new JSONWriter().write(alipayRequest.getBizModel(), true));
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException e) {
                AlipayLogger.logBizError(e);
            }
            requestBody.append(new JSONWriter().write(apiParams, false));
            if (index == requestList.size() - 1) continue;
            requestBody.append(BATCH_API_DEFAULT_SPLIT);
        }
        appParams.put("biz_content", requestBody.toString());
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)appParams.get("biz_content"))) {
                throw new AlipayApiException("\ufffd\ufffd\u01f0API\ufffd\ufffd\u05a7\ufffd\u05bc\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            if (StringUtils.isEmpty(this.encryptType) || this.getEncryptor() == null) {
                throw new AlipayApiException("API\ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\ufffd\ufffd\u0723\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u053f\ufffd\ufffd\ufffd\u037a\u037c\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            String encryptContent = this.getEncryptor().encrypt((String)appParams.get("biz_content"), this.encryptType, this.charset);
            appParams.put("biz_content", encryptContent);
        }
        requestHolder.setApplicationParams(appParams);
        if (!StringUtils.isEmpty(this.signType)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", this.getSigner().sign(signContent, this.signType, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        return requestHolder;
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request) throws AlipayApiException {
        return this.pageExecute(request, "POST");
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request, String httpMethod) throws AlipayApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        AlipayResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (AlipayResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(e);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            rsp.setBody(this.getRedirectUrl(requestHolder));
        } else {
            String baseUrl = this.getRequestUrl(requestHolder);
            rsp.setBody(WebUtils.buildForm(baseUrl, requestHolder.getApplicationParams()));
        }
        return (T)rsp;
    }

    @Override
    public <T extends AlipayResponse> T sdkExecute(AlipayRequest<T> request) throws AlipayApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getSdkParams(requestHolder));
        }
        AlipayResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (AlipayResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(e);
        }
        rsp.setBody(this.getSdkParams(requestHolder));
        return (T)rsp;
    }

    @Override
    public <TR extends AlipayResponse, T extends AlipayRequest<TR>> TR parseAppSyncResult(Map<String, String> result, Class<T> requsetClazz) throws AlipayApiException {
        AlipayResponse tRsp = null;
        String rsp = result.get("result");
        try {
            AlipayRequest request = (AlipayRequest)requsetClazz.newInstance();
            Class responseClazz = request.getResponseClass();
            if (StringUtils.isEmpty(rsp)) {
                tRsp = (AlipayResponse)responseClazz.newInstance();
                tRsp.setCode("20000");
                tRsp.setSubCode("ACQ.SYSTEM_ERROR");
                tRsp.setSubMsg(result.get("memo"));
            } else {
                AlipayParser parser = null;
                parser = "xml".equals(this.format) ? new ObjectXmlParser(responseClazz) : new ObjectJsonParser(responseClazz);
                tRsp = parser.parse(rsp);
                tRsp.setBody(rsp);
                this.checkResponseSign(request, parser, rsp, tRsp.isSuccess());
                if (!tRsp.isSuccess()) {
                    AlipayLogger.logBizError(rsp);
                }
            }
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError(rsp);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        return (TR)tRsp;
    }

    private <T extends AlipayResponse> RequestParametersHolder getRequestHolderWithSign(AlipayRequest<?> request, String accessToken, String appAuthToken) throws AlipayApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap appParams = new AlipayHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        try {
            if (request.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("biz_content")) && request.getBizModel() != null) {
                appParams.put("biz_content", new JSONWriter().write(request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            AlipayLogger.logBizError(e);
        }
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)appParams.get("biz_content"))) {
                throw new AlipayApiException("\ufffd\ufffd\u01f0API\ufffd\ufffd\u05a7\ufffd\u05bc\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            if (StringUtils.isEmpty(this.encryptType) || this.getEncryptor() == null) {
                throw new AlipayApiException("API\ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\ufffd\ufffd\u0723\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u053f\ufffd\ufffd\ufffd\u037a\u037c\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            String encryptContent = this.getEncryptor().encrypt((String)appParams.get("biz_content"), this.encryptType, this.charset);
            appParams.put("biz_content", encryptContent);
        }
        if (!StringUtils.isEmpty(appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = "UTF-8";
        }
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", request.getApiVersion());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.signType);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("return_url", request.getReturnUrl());
        protocalMustParams.put("charset", this.charset);
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("auth_token", accessToken);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-3.7.26.ALL");
        protocalOptParams.put("prod_code", request.getProdCode());
        requestHolder.setProtocalOptParams(protocalOptParams);
        if (!StringUtils.isEmpty(this.signType)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", this.getSigner().sign(signContent, this.signType, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        return requestHolder;
    }

    private String getRequestUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), this.charset);
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private String getRedirectUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuffer urlSb = new StringBuffer(this.serverUrl);
        try {
            Map<String, String> sortedMap = AlipaySignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append("?");
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private String getSdkParams(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuffer urlSb = new StringBuffer();
        try {
            Map<String, String> sortedMap = AlipaySignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(sortedMap, this.charset);
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private <T extends AlipayResponse> T _execute(AlipayRequest<T> request, AlipayParser<T> parser, String authToken, String appAuthToken) throws AlipayApiException {
        long beginTime = System.currentTimeMillis();
        Map<String, Object> rt = this.doPost(request, authToken, appAuthToken);
        if (rt == null) {
            return null;
        }
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        AlipayResponse tRsp = null;
        try {
            ResponseEncryptItem responseItem = this.decryptResponse(request, rt, parser);
            tRsp = (AlipayResponse)parser.parse(responseItem.getRealContent());
            tRsp.setBody(responseItem.getRealContent());
            this.checkResponseSign(request, parser, responseItem.getRespContent(), tRsp.isSuccess());
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw new AlipayApiException(e);
        }
        tRsp.setParams((AlipayHashMap)rt.get("textParams"));
        if (!tRsp.isSuccess()) {
            AlipayLogger.logErrorScene(rt, tRsp, "", costTimeMap);
        } else {
            AlipayLogger.logBizSummary(rt, tRsp, costTimeMap);
        }
        return (T)tRsp;
    }

    private <T extends AlipayResponse> Map<String, Object> doPost(AlipayRequest<T> request, String accessToken, String appAuthToken) throws AlipayApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, accessToken, appAuthToken);
        String url = this.getRequestUrl(requestHolder);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            if (request instanceof AlipayUploadRequest) {
                AlipayUploadRequest uRequest = (AlipayUploadRequest)request;
                Map<String, FileItem> fileParams = AlipayUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), fileParams, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            } else {
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", url);
        return result;
    }

    private <T extends AlipayResponse> void checkResponseSign(AlipayRequest<T> request, AlipayParser<T> parser, String responseBody, boolean responseIsSucess) throws AlipayApiException {
        if (this.getSignChecker() != null) {
            boolean rsaCheckContent;
            SignItem signItem = parser.getSignItem(request, responseBody);
            if (signItem == null) {
                throw new AlipayApiException("sign check fail: Body is Empty!");
            }
            if ((responseIsSucess || !responseIsSucess && !StringUtils.isEmpty(signItem.getSign())) && !(rsaCheckContent = this.getSignChecker().check(signItem.getSignSourceDate(), signItem.getSign(), this.signType, this.charset))) {
                if (!StringUtils.isEmpty(signItem.getSignSourceDate()) && signItem.getSignSourceDate().contains("\\/")) {
                    String srouceData = signItem.getSignSourceDate().replace("\\/", "/");
                    boolean jsonCheck = this.getSignChecker().check(srouceData, signItem.getSign(), this.signType, this.charset);
                    if (!jsonCheck) {
                        throw new AlipayApiException("sign check fail: check Sign and Data Fail\ufffd\ufffdJSON also\ufffd\ufffd");
                    }
                } else {
                    throw new AlipayApiException("sign check fail: check Sign and Data Fail!");
                }
            }
        }
    }

    private <T extends AlipayResponse> ResponseEncryptItem decryptResponse(AlipayRequest<T> request, Map<String, Object> rt, AlipayParser<T> parser) throws AlipayApiException {
        String responseBody = (String)rt.get("rsp");
        String realBody = null;
        realBody = request.isNeedEncrypt() ? parser.decryptSourceData(request, responseBody, this.format, this.getDecryptor(), this.encryptType, this.charset) : (String)rt.get("rsp");
        return new ResponseEncryptItem(responseBody, realBody);
    }

    void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setSignType(String signType) {
        this.signType = signType;
    }

    void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public abstract Signer getSigner();

    public abstract SignChecker getSignChecker();

    public abstract Encryptor getEncryptor();

    public abstract Decryptor getDecryptor();

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

