/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.boot.logging;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.log.LoggerSpaceManager;
import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.SpaceInfo;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.Log4j2LoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LogbackLoggerSpaceFactory;
import com.alipay.sofa.common.log.spi.ReInitializeChecker;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class CommonLoggingApplicationListener
implements ReInitializeChecker,
ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final AtomicBoolean isReInitialized = new AtomicBoolean(false);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (isReInitialized.compareAndSet(false, true)) {
            this.reInitializeLog(this.loadApplicationEnvironment(event.getEnvironment()));
        }
    }

    public boolean isReInitialize() {
        return isReInitialized.get();
    }

    public void setReInitialize(boolean value) {
        isReInitialized.set(value);
    }

    private void reInitializeLog(Map<String, String> context) {
        for (String string : context.keySet()) {
            if (!string.startsWith("sofa.middleware.log.") || string.equals("sofa.middleware.log.console")) continue;
            int index = "sofa.middleware.log.".length();
            int end = string.length() - 8;
            String spaceId = string.substring(index, end);
            LoggerSpaceManager.getLoggerBySpace((String)spaceId, (String)spaceId);
        }
        for (Map.Entry entry : MultiAppLoggerSpaceManager.getSpacesMap().entrySet()) {
            SpaceId spaceId = (SpaceId)entry.getKey();
            SpaceInfo spaceInfo = (SpaceInfo)entry.getValue();
            ReportUtil.reportDebug((String)("Re-initialize log of " + spaceId.getSpaceName()));
            AbstractLoggerSpaceFactory abstractLoggerSpaceFactory = spaceInfo.getAbstractLoggerSpaceFactory();
            if (abstractLoggerSpaceFactory instanceof LogbackLoggerSpaceFactory) {
                ((LogbackLoggerSpaceFactory)abstractLoggerSpaceFactory).reInitialize(context);
            }
            if (!(abstractLoggerSpaceFactory instanceof Log4j2LoggerSpaceFactory)) continue;
            ((Log4j2LoggerSpaceFactory)abstractLoggerSpaceFactory).reInitialize(context);
        }
    }

    private Map<String, String> loadApplicationEnvironment(ConfigurableEnvironment environment) {
        HashMap<String, String> context = new HashMap<String, String>();
        this.readLogConfiguration("logging.path", environment.getProperty("logging.path"), context, Constants.LOGGING_PATH_DEFAULT);
        this.readLogConfiguration("loggingRoot", environment.getProperty("loggingRoot"), context, (String)context.get("logging.path"));
        this.readLogConfiguration("file.encoding", environment.getProperty("file.encoding"), context);
        LogEnvUtils.keepCompatible(context, (boolean)true);
        HashSet<String> configKeys = new HashSet<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            configKeys.addAll(Arrays.asList(((EnumerablePropertySource)propertySource).getPropertyNames()));
        }
        for (String key : configKeys) {
            if (!LogEnvUtils.filterAllLogConfig((String)key)) continue;
            this.addToGlobalSystemProperties(key, environment.getProperty(key));
            this.readLogConfiguration(key, environment.getProperty(key), context);
        }
        return context;
    }

    private void addToGlobalSystemProperties(String key, String value) {
        if (!StringUtil.isBlank((String)key) && !StringUtil.isBlank((String)value)) {
            LogEnvUtils.processGlobalSystemLogProperties().put(key, value);
        }
    }

    private void readLogConfiguration(String key, String value, Map<String, String> context) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        }
    }

    private void readLogConfiguration(String key, String value, Map<String, String> context, String defaultValue) {
        if (!StringUtil.isBlank((String)value)) {
            context.put(key, value);
        } else {
            context.put(key, defaultValue);
        }
    }

    public int getOrder() {
        return -2147483628;
    }
}

