/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.env;

import com.alipay.sofa.common.log.Constants;
import com.alipay.sofa.common.utils.AssertUtil;
import com.alipay.sofa.common.utils.ClassUtil;
import com.alipay.sofa.common.utils.ProcessIdUtil;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.util.HashMap;
import java.util.Map;

public final class LogEnvUtils {
    private static volatile Map<String, String> globalSystemProperties;

    private LogEnvUtils() {
    }

    public static boolean isLogbackUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("ch.qos.logback.classic.LoggerContext") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4j2Usable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.apache.logging.slf4j.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isLog4jUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.Log4jLoggerFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isCommonsLoggingUsable(ClassLoader spaceClassloader) {
        AssertUtil.notNull(spaceClassloader);
        try {
            return spaceClassloader.loadClass("org.slf4j.impl.JCLLoggerAdapter") != null && spaceClassloader.loadClass("org.apache.commons.logging.impl.Log4JLogger") != null && spaceClassloader.loadClass("org.apache.log4j.Logger") != null && spaceClassloader.loadClass("org.apache.commons.logging.Log") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, String> processGlobalSystemLogProperties() {
        String lowerCaseKey;
        if (globalSystemProperties != null) {
            return globalSystemProperties;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("PID", ProcessIdUtil.getProcessId());
        properties.put("file.encoding", System.getProperty("file.encoding", "UTF-8"));
        String loggingPath = System.getProperty("logging.path");
        String loggingRoot = System.getProperty("loggingRoot");
        if (!StringUtil.isBlank(loggingPath)) {
            loggingRoot = loggingPath;
        } else if (!StringUtil.isBlank(loggingRoot)) {
            loggingPath = loggingRoot;
        } else {
            loggingPath = Constants.LOGGING_PATH_DEFAULT;
            loggingRoot = Constants.LOGGING_PATH_DEFAULT;
        }
        properties.put("logging.path", loggingPath);
        properties.put("loggingRoot", loggingRoot);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            lowerCaseKey = entry.getKey().toLowerCase();
            if (!lowerCaseKey.startsWith("logging.level.") && !lowerCaseKey.startsWith("logging.path.") && !lowerCaseKey.startsWith("logging.config.")) continue;
            properties.put(lowerCaseKey, entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(lowerCaseKey = ((String)entry.getKey()).toLowerCase()).startsWith("logging.level.") && !lowerCaseKey.startsWith("logging.path.") && !lowerCaseKey.startsWith("logging.config.")) continue;
            properties.put(lowerCaseKey, (String)entry.getValue());
        }
        globalSystemProperties = properties;
        LogEnvUtils.keepCompatible(globalSystemProperties, !LogEnvUtils.isLogStarterExist());
        return globalSystemProperties;
    }

    public static String getLogConfEnvSuffix(String spaceName) {
        String logEnvConfig = System.getProperty("log.env.suffix", "");
        String[] spaceNameToEnvSuffix = logEnvConfig.split("&");
        String suffix = null;
        for (int i = 0; i < spaceNameToEnvSuffix.length && suffix == null; ++i) {
            String envConf = spaceNameToEnvSuffix[i];
            String[] conf = envConf.split(":");
            if (conf.length != 2 || !conf[0].equals(spaceName)) continue;
            if (!conf[1].isEmpty()) {
                conf[1] = "." + conf[1];
            }
            suffix = conf[1];
        }
        String string = suffix = suffix == null ? "" : suffix;
        if (!suffix.isEmpty()) {
            ReportUtil.reportDebug(spaceName + " log configuration: " + "log-conf.xml" + suffix);
        }
        return suffix;
    }

    public static void keepCompatible(Map<String, String> context, boolean keep) {
        if (!keep) {
            return;
        }
        String loggingPath = System.getProperty("logging.path", context.get("logging.path"));
        String fileEncoding = System.getProperty("file.encoding", context.get("file.encoding"));
        System.setProperty("logging.path", loggingPath);
        System.setProperty("loggingRoot", System.getProperty("loggingRoot", loggingPath));
        System.setProperty("file.encoding", fileEncoding);
    }

    public static boolean isLogStarterExist() {
        return ClassUtil.isPresent("com.alipay.sofa.common.boot.logging.CommonLoggingApplicationListener");
    }

    public static boolean filterAllLogConfig(String key) {
        return key.startsWith("sofa.middleware.log.") || key.startsWith("logging.level.") || key.startsWith("logging.path.") || key.startsWith("logging.config.") || key.equals("logging.path") || key.equals("loggingRoot") || key.equals("file.encoding");
    }
}

