/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.protostuff;

import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.protostuff.ProtostuffHelper;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.HashMap;
import java.util.Map;

@Extension(value="protostuff", code=12)
public class ProtostuffSerializer
extends AbstractSerializer {
    private final ProtostuffHelper protostuffHelper = new ProtostuffHelper();
    private static final String METHOD_TOBYTEARRAY = "toByteArray";
    private static final String METHOD_PARSEFROM = "parseFrom";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) throws SofaRpcException {
        if (object == null) {
            throw this.buildSerializeError("Unsupported null message!");
        }
        if (object instanceof SofaRequest) {
            return this.encodeSofaRequest((SofaRequest)object, context);
        }
        if (object instanceof SofaResponse) {
            return this.encodeSofaResponse((SofaResponse)object, context);
        }
        Class<?> clazz = object.getClass();
        Schema schema = RuntimeSchema.getSchema(clazz);
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            ByteArrayWrapperByteBuf byteArrayWrapperByteBuf = new ByteArrayWrapperByteBuf(ProtostuffIOUtil.toByteArray((Object)object, (Schema)schema, (LinkedBuffer)buffer));
            return byteArrayWrapperByteBuf;
        }
        finally {
            buffer.clear();
        }
    }

    protected AbstractByteBuf encodeSofaRequest(SofaRequest sofaRequest, Map<String, String> context) throws SofaRpcException {
        Object[] args = sofaRequest.getMethodArgs();
        if (args.length > 1) {
            throw this.buildSerializeError("Protobuf only support one parameter!");
        }
        return this.encode(args[0], context);
    }

    protected AbstractByteBuf encodeSofaResponse(SofaResponse sofaResponse, Map<String, String> context) throws SofaRpcException {
        Object appResponse;
        AbstractByteBuf byteBuf = sofaResponse.isError() ? this.encode(sofaResponse.getErrorMsg(), context) : ((appResponse = sofaResponse.getAppResponse()) instanceof Throwable ? this.encode(((Throwable)appResponse).getMessage(), context) : this.encode(appResponse, context));
        return byteBuf;
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        Schema schema = RuntimeSchema.getSchema((Class)clazz);
        Object fooParsed = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])data.array(), (Object)fooParsed, (Schema)schema);
        return fooParsed;
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        if (template instanceof SofaRequest) {
            this.decodeSofaRequest(data, (SofaRequest)template, context);
        } else if (template instanceof SofaResponse) {
            this.decodeSofaResponse(data, (SofaResponse)template, context);
        } else {
            throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
        }
    }

    private void decodeSofaRequest(AbstractByteBuf data, SofaRequest sofaRequest, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        sofaRequest.setTargetServiceUniqueName(targetService);
        String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetService);
        sofaRequest.setInterfaceName(interfaceName);
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        sofaRequest.setMethodName(methodName);
        String targetApp = head.remove("sofa_head_target_app");
        if (targetApp != null) {
            sofaRequest.setTargetAppName(targetApp);
        }
        this.parseRequestHeader("rpc_trace_context", head, sofaRequest);
        if (RpcInvokeContext.isBaggageEnable()) {
            this.parseRequestHeader("rpc_req_baggage", head, sofaRequest);
        }
        for (Map.Entry<String, String> entry : head.entrySet()) {
            sofaRequest.addRequestProp(entry.getKey(), entry.getValue());
        }
        Class requestClass = this.protostuffHelper.getReqClass(targetService, sofaRequest.getMethodName());
        Object pbReq = this.decode(data, requestClass, head);
        sofaRequest.setMethodArgs(new Object[]{pbReq});
        sofaRequest.setMethodArgSigs(new String[]{requestClass.getName()});
    }

    private void parseRequestHeader(String key, Map<String, String> headerMap, SofaRequest sofaRequest) {
        HashMap<String, String> traceMap = new HashMap<String, String>(8);
        CodecUtils.treeCopyTo(key + ".", headerMap, traceMap, true);
        if (!traceMap.isEmpty()) {
            sofaRequest.addRequestProp(key, traceMap);
        }
    }

    private void decodeSofaResponse(AbstractByteBuf data, SofaResponse sofaResponse, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        boolean isError = false;
        if ("true".equals(head.remove("sofa_head_response_error"))) {
            isError = true;
        }
        if (!head.isEmpty()) {
            sofaResponse.setResponseProps(head);
        }
        if (isError) {
            String errorMessage = (String)this.decode(data, String.class, head);
            sofaResponse.setErrorMsg(errorMessage);
        } else {
            Class responseClass = this.protostuffHelper.getResClass(targetService, methodName);
            Object pbRes = this.decode(data, responseClass, head);
            sofaResponse.setAppResponse(pbRes);
        }
    }
}

