/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.consul;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.consul.ConsulRegistryProperties;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class HealthServiceInformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthServiceInformer.class);
    private String serviceName;
    private String tag;
    private Response<List<HealthService>> currentData;
    private ConsulClient consulClient;
    private ConsulRegistryProperties properties;
    private List<ProviderInfoListener> listeners;
    private ScheduledExecutorService watchExecutor;

    public HealthServiceInformer(String serviceName, String tag, ConsulClient consulClient, ConsulRegistryProperties properties) {
        this.serviceName = serviceName;
        this.tag = tag;
        this.consulClient = consulClient;
        this.properties = properties;
        this.listeners = new ArrayList<ProviderInfoListener>();
    }

    private void watchHealthService() {
        try {
            HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.tag).setQueryParams(new QueryParams((long)this.properties.getWatchTimeout(), this.currentData.getConsulIndex().longValue())).setPassing(true).build();
            Response response = this.consulClient.getHealthServices(this.serviceName, request);
            if (response.getConsulIndex().equals(this.currentData.getConsulIndex())) {
                return;
            }
            this.currentData = response;
            ProviderGroup providerGroup = new ProviderGroup(this.currentProviders());
            this.listeners.stream().filter(Objects::nonNull).forEach(l -> l.updateProviders(providerGroup));
        }
        catch (Exception e) {
            LOGGER.error("Consul watch health service failed.", e);
        }
    }

    public void init() {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.tag).setQueryParams(QueryParams.DEFAULT).setPassing(true).build();
        this.currentData = this.consulClient.getHealthServices(this.serviceName, request);
        this.watchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.watchExecutor.scheduleWithFixedDelay(this::watchHealthService, this.properties.getLookupInterval(), this.properties.getLookupInterval(), TimeUnit.MILLISECONDS);
    }

    public List<ProviderInfo> currentProviders() {
        return ((List)this.currentData.getValue()).stream().map(HealthService::getService).map(service -> ProviderHelper.toProviderInfo(RegistryUtils.convertInstanceToUrl(service.getAddress(), service.getPort(), service.getMeta()))).collect(Collectors.toList());
    }

    public void addListener(ProviderInfoListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProviderInfoListener listener) {
        this.listeners.remove(listener);
    }

    public int getListenerSize() {
        return this.listeners.size();
    }

    public void shutdown() {
        this.watchExecutor.shutdown();
    }
}

