/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NacosRegistryHelper {
    static final String DEFAULT_CLUSTER = "default-cluster";

    NacosRegistryHelper() {
    }

    static String buildServiceName(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getServiceName(config) + ":DEFAULT";
        }
        return ConfigUniqueNameGenerator.getServiceName(config) + ":" + protocol;
    }

    static List<Instance> convertProviderToInstances(ProviderConfig providerConfig) {
        List<ServerConfig> servers = providerConfig.getServer();
        if (servers != null && !servers.isEmpty()) {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            for (ServerConfig server : servers) {
                String serviceName = NacosRegistryHelper.buildServiceName(providerConfig, server.getProtocol());
                Instance instance = new Instance();
                instance.setClusterName(DEFAULT_CLUSTER);
                instance.setServiceName(serviceName);
                String host = server.getVirtualHost();
                if (host == null && (NetUtils.isLocalHost(host = server.getHost()) || NetUtils.isAnyHost(host))) {
                    host = SystemInfo.getLocalHost();
                }
                instance.setIp(host);
                instance.setPort(server.getPort());
                Map<String, String> metaData = RegistryUtils.convertProviderToMap(providerConfig, server);
                instance.setMetadata(metaData);
                instances.add(instance);
            }
            return instances;
        }
        return null;
    }

    static List<ProviderInfo> convertInstancesToProviders(List<Instance> allInstances) {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        if (CommonUtils.isEmpty(allInstances)) {
            return providerInfos;
        }
        for (Instance instance : allInstances) {
            String url = NacosRegistryHelper.convertInstanceToUrl(instance);
            ProviderInfo providerInfo = ProviderHelper.toProviderInfo(url);
            providerInfos.add(providerInfo);
        }
        return providerInfos;
    }

    private static String convertInstanceToUrl(Instance instance) {
        HashMap metaData = instance.getMetadata();
        if (metaData == null) {
            metaData = new HashMap();
        }
        String uri = "";
        String protocol = (String)metaData.get("protocol");
        if (StringUtils.isNotEmpty(protocol)) {
            uri = protocol + "://";
        }
        uri = uri + instance.getIp() + ":" + instance.getPort();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : metaData.entrySet()) {
            sb.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        if (sb.length() > 0) {
            uri = uri + sb.replace(0, 1, "?").toString();
        }
        return uri;
    }
}

